#include	"..\DLL\d_iNES.h"

static	struct
{
	u8 IRQenabled;
	u16_n IRQcounter;
	u8 PRG;
}	Mapper;

static	void	Sync (void)
{
	MP->SetPRG_ROM8(0x6,6);
	MP->SetPRG_ROM8(0x8,4);
	MP->SetPRG_ROM8(0xA,5);
	MP->SetPRG_ROM8(0xC,Mapper.PRG);
	MP->SetPRG_ROM8(0xE,7);
	MP->SetCHR_ROM8(0,0);
}

static	void	__cdecl	SaveMI (Ar128 MI)
{
	u8 x = 0;
	MI[x++] = Mapper.IRQenabled;
	MI[x++] = Mapper.IRQcounter.b0;
	MI[x++] = Mapper.IRQcounter.b1;
	MI[x++] = Mapper.PRG;
}

static	void	__cdecl	LoadMI (const Ar128 MI)
{
	u8 x = 0;
	Mapper.IRQenabled	= MI[x++];
	Mapper.IRQcounter.b0	= MI[x++];
	Mapper.IRQcounter.b1	= MI[x++];
	Mapper.PRG		= MI[x++];
	Sync();
}

static	void	__cdecl	HBlank (int Scanline, int Byte2001)
{
	if (Mapper.IRQenabled)
	{
		Mapper.IRQcounter.s0 += 114;
		if (Mapper.IRQcounter.s0 >= 4096)
		{
			Mapper.IRQcounter.s0 -= 4096;
			MP->IRQ();
		}
	}
}

static	void	__cdecl	Write89 (int Bank, int Where, int What)
{
	Mapper.IRQenabled = 0;
	Mapper.IRQcounter.s0 = 0;
}

static	void	__cdecl	WriteAB (int Bank, int Where, int What)
{
	Mapper.IRQenabled = 1;
}

static	void	__cdecl	WriteEF (int Bank, int Where, int What)
{
	Mapper.PRG = What & 7;
	Sync();
}

static	void	__cdecl	UnloadMapper (void)
{
	iNES_UnloadROM();
}

static	void	__cdecl	InitMapper (const PMapperParam _MP, int IsHardReset)
{
	MP = _MP;
	MP->SetWriteHandler(0x8,Write89);
	MP->SetWriteHandler(0x9,Write89);
	MP->SetWriteHandler(0xA,WriteAB);
	MP->SetWriteHandler(0xB,WriteAB);
	MP->SetWriteHandler(0xE,WriteEF);
	MP->SetWriteHandler(0xF,WriteEF);

	Mapper.IRQenabled = 0;
	Mapper.IRQcounter.s0 = 0;
	Mapper.PRG = 0;

	iNES_InitROM();
	Sync();
}

CTMapperInfo	MapperInfo_040 =
{
	"SMB2j Pirate",
	40,
	MS_Full,
	8192,
	InitMapper,
	UnloadMapper,
	HBlank,
	NULL,
	SaveMI,
	LoadMI,
	NULL,
	NULL
};