#include	"..\DLL\d_iNES.h"
#include	"..\Hardware\h_74xx.h"

static	struct
{
	u8 Game;
}	Mapper;

static	void	Sync (void)
{
	MP->SetPRG_ROM32(0x8,((Mapper.Game & 0x0F) << 1) | (_74xx.Data & 0x01));
	MP->SetCHR_ROM8(0,((Mapper.Game & 0xF0) >> 1) | ((_74xx.Data & 0x70) >> 4));
}

static	void	__cdecl	SaveMI (Ar128 MI)
{
	u8 x = 0;
	x = _74xx_SaveMI_D(MI,x);
	MI[x++] = Mapper.Game;
}

static	void	__cdecl	LoadMI (const Ar128 MI)
{
	u8 x = 0;
	x = _74xx_LoadMI_D(MI,x);
	Mapper.Game	= MI[x++];
	Sync();
}

static	void	__cdecl	Write (int Bank, int Where, int What)
{
	Mapper.Game = What;
	Sync();
}

static	void	__cdecl	UnloadMapper (void)
{
	iNES_UnloadROM();
	_74xx_Destroy();
}

static	void	__cdecl	InitMapper (const PMapperParam _MP, int IsHardReset)
{
	u8 x;
	MP = _MP;
	for (x = 0x6; x < 0x8; x++)
		MP->SetWriteHandler(x,Write);
	Mapper.Game = 0;
	iNES_InitROM();
	_74xx_Init(Sync,IsHardReset,FALSE);
}

CTMapperInfo	MapperInfo_046 =
{
	"GameStation/RumbleStation",
	46,
	MS_Full,
	32768,
	InitMapper,
	UnloadMapper,
	NULL,
	NULL,
	SaveMI,
	LoadMI,
	NULL,
	NULL
};
