#include	"..\DLL\d_iNES.h"
#include	"..\Hardware\h_MMC3.h"

static	struct
{
	u8 Reg;
}	Mapper;

static	void	Sync (void)
{
	MMC3_SyncMirror();
	if (Mapper.Reg & 1)
		MMC3_SyncPRG(0xF,(Mapper.Reg & 0xC0) >> 2);
	else	MP->SetPRG_ROM32(0x8,(Mapper.Reg & 0x30) >> 4);
	MMC3_SyncCHR_ROM(0x7F,(Mapper.Reg & 0xC0) << 1);
}

static	void	__cdecl	SaveMI (Ar128 MI)
{
	u8 x = 0;
	x = MMC3_SaveMI(MI,x);
	MI[x++] = Mapper.Reg;
}

static	void	__cdecl	LoadMI (const Ar128 MI)
{
	u8 x = 0;
	x = MMC3_LoadMI(MI,x);
	Mapper.Reg	= MI[x++];
	Sync();
}

static	void	__cdecl	Write (int Bank, int Where, int What)
{
	Mapper.Reg = What;
	Sync();
}

static	void	__cdecl	UnloadMapper (void)
{
	iNES_UnloadROM();
	MMC3_Destroy();
}

static	void	__cdecl	InitMapper (const PMapperParam _MP, int IsHardReset)
{
	u8 x;
	MP = _MP;
	for (x = 0x6; x < 0x8; x++)
		MP->SetWriteHandler(0x6,Write);
	iNES_InitROM();
	Mapper.Reg = 0;
	MMC3_Init(Sync);
}

CTMapperInfo	MapperInfo_049 =
{
	"1993 Super HiK 4-in-1 (MMC3)",
	49,
	MS_Full,
	8192,
	InitMapper,
	UnloadMapper,
	MMC3_HBlank,
	NULL,
	SaveMI,
	LoadMI,
	NULL,
	NULL
};