#include	"..\DLL\d_iNES.h"
#include	"..\Hardware\h_74xx.h"

static	struct
{
	u8 Jumper;
}	Mapper;

static	void	Sync (void)
{
	u8 x;
	MP->SetCHR_ROM8(0,_74xx.Addr & 0x07);
	MP->SetPRG_ROM32(0x8,(_74xx.Addr & 0x70) >> 4);
	if (_74xx.Addr & 0x08)
		MP->Mirror_H();
	else	MP->Mirror_V();
	if (_74xx.Addr & 0x100)
		for (x = 0x8; x < 0x10; x++)
		{
			MP->SetPRG_RAM4(x,x-8);
			memset(MP->GetPRG_Ptr4(x),Mapper.Jumper,0x1000);
		}
}

static	void	__cdecl	SaveMI (Ar128 MI)
{
	u8 x = 0;
	x = _74xx_SaveMI_A(MI,x);
	MI[x++] = Mapper.Jumper;
}

static	void	__cdecl	LoadMI (const Ar128 MI)
{
	u8 x = 0;
	x = _74xx_LoadMI_A(MI,x);
	Mapper.Jumper = MI[x++];
}

static	void	__cdecl	UnloadMapper (void)
{
	iNES_UnloadROM();
	_74xx_Destroy();
}

static	void	__cdecl	MenuClick (int Command, int Parm1, int Parm2, int Parm3)
{
	switch (Command)
	{
	case 0:	switch (Parm1)
		{
		case 0:	Mapper.Jumper ^= 0x01;	break;
		case 1:	Mapper.Jumper ^= 0x02;	break;
		}	break;
	}
}

static	void	__cdecl	InitMapper (const PMapperParam _MP, int IsHardReset)
{
	MP = _MP;
	_74xx_Init(Sync,IsHardReset,FALSE);
	MP->AddMenuItem(MP->GetMenuRoot(),"Jumper 0",0,0,-1,-1,(Mapper.Jumper & 0x01) ? MENU_CHECKED : MENU_UNCHECKED);
	MP->AddMenuItem(MP->GetMenuRoot(),"Jumper 1",0,1,-1,-1,(Mapper.Jumper & 0x02) ? MENU_CHECKED : MENU_UNCHECKED);
	iNES_InitROM();
}

CTMapperInfo	MapperInfo_059 =
{
	"T3H53",
	59,
	MS_Full,
	32768,
	InitMapper,
	UnloadMapper,
	NULL,
	NULL,
	SaveMI,
	LoadMI,
	NULL,
	MenuClick
};