#include	"..\DLL\d_iNES.h"
#include	"..\Hardware\h_74xx.h"

static	void	Sync (void)
{
	union
	{
		struct
		{
			unsigned PRG     : 4;
			unsigned PRGsize : 1;
			unsigned PRG16   : 1;
			unsigned         : 1;
			unsigned Mir_HV  : 1;
			unsigned         : 8;
		};
		struct
		{
			unsigned Addr       :16;
		};
	}	Latch;
	Latch.Addr = _74xx.Addr;
	MP->SetCHR_RAM8(0,0);
	if (Latch.PRGsize)
	{
		MP->SetPRG_ROM16(0x8,(Latch.PRG << 1) | Latch.PRG16);
		MP->SetPRG_ROM16(0xC,(Latch.PRG << 1) | Latch.PRG16);
	}
	else	MP->SetPRG_ROM32(0x8,Latch.PRG);
	if (Latch.Mir_HV)
		MP->Mirror_H();
	else	MP->Mirror_V();
}

static	void	__cdecl	SaveMI (Ar128 MI)
{
	_74xx_SaveMI_A(MI,0);
}

static	void	__cdecl	LoadMI (const Ar128 MI)
{
	_74xx_LoadMI_A(MI,0);
}

static	void	__cdecl	UnloadMapper (void)
{
	iNES_UnloadROM();
	_74xx_Destroy();
}

static	void	__cdecl	InitMapper (const PMapperParam _MP, int IsHardReset)
{
	MP = _MP;
	_74xx_Init(Sync,IsHardReset,FALSE);
}

CTMapperInfo	MapperInfo_061 =
{
	"20-in-1",
	61,
	MS_Full,
	32768,
	InitMapper,
	UnloadMapper,
	NULL,
	NULL,
	SaveMI,
	LoadMI,
	NULL,
	NULL
};