#include	"..\DLL\d_iNES.h"

static	struct
{
	u8 IRQenabled, IRQcounter, IRQlatch;
	u8 Cmd;
	u8 PRG[3];
	u8 CHR[8];
	u8 Mirror;
}	Mapper;

static	void	Sync (void)
{
	u8 x, SwCHR = (Mapper.Cmd & 0x80) >> 5;
	if (Mapper.Mirror & 0x1)
		MP->Mirror_H();
	else	MP->Mirror_V();

	if (Mapper.Cmd & 0x40)
	{
		MP->SetPRG_ROM8(0xA,Mapper.PRG[0]);
		MP->SetPRG_ROM8(0xC,Mapper.PRG[1]);
		MP->SetPRG_ROM8(0x8,Mapper.PRG[2]);
	}
	else
	{
		MP->SetPRG_ROM8(0x8,Mapper.PRG[0]);
		MP->SetPRG_ROM8(0xA,Mapper.PRG[1]);
		MP->SetPRG_ROM8(0xC,Mapper.PRG[2]);
	}
	MP->SetPRG_ROM8(0xE,-1);

	for (x = 0; x < 8; x++)
		MP->SetCHR_ROM1(SwCHR ^ x,Mapper.CHR[x]);
}

static	void	__cdecl	SaveMI (Ar128 MI)
{
	u8 x = 0, i;
			MI[x++] = Mapper.IRQcounter;
			MI[x++] = Mapper.IRQlatch;
			MI[x++] = Mapper.IRQenabled;
			MI[x++] = Mapper.Cmd;
for (i = 0; i < 3; i++) MI[x++] = Mapper.PRG[i];
for (i = 0; i < 8; i++)	MI[x++] = Mapper.CHR[i];
			MI[x++] = Mapper.Mirror;
}

static	void	__cdecl	LoadMI (const Ar128 MI)
{
	u8 x = 0, i;
			Mapper.IRQcounter	= MI[x++];
			Mapper.IRQlatch		= MI[x++];
			Mapper.IRQenabled	= MI[x++];
			Mapper.Cmd		= MI[x++];
for (i = 0; i < 3; i++) Mapper.PRG[i]		= MI[x++];
for (i = 0; i < 8; i++)	Mapper.CHR[i]		= MI[x++];
			Mapper.Mirror		= MI[x++];
	Sync();
}

static	void	__cdecl	HBlank (int Scanline, int Byte2001)
{
	if ((Scanline < 0) || (Scanline > 239)) return;
	if ((Mapper.IRQenabled) && ((Byte2001 & 0x18)))
	{
		if (Mapper.IRQcounter == 0)
		{
			Mapper.IRQcounter = Mapper.IRQlatch;
			MP->IRQ();
		}
		else	Mapper.IRQcounter--;
	}
}

static	void	__cdecl	Write89 (int Bank, int Where, int What)
{
	if (Where & 1)
		switch (Mapper.Cmd & 0xF)
		{
		case 0:	Mapper.CHR[0] = What;	break;
		case 8:	Mapper.CHR[1] = What;	break;
		case 1:	Mapper.CHR[2] = What;	break;
		case 9:	Mapper.CHR[3] = What;	break;
		case 2:	Mapper.CHR[4] = What;	break;
		case 3:	Mapper.CHR[5] = What;	break;
		case 4:	Mapper.CHR[6] = What;	break;
		case 5:	Mapper.CHR[7] = What;	break;
		case 6:	Mapper.PRG[0] = What;	break;
		case 7:	Mapper.PRG[1] = What;	break;
		case 15:Mapper.PRG[2] = What;	break;
		}
	else	Mapper.Cmd = What;
	Sync();
}

static	void	__cdecl	WriteAB (int Bank, int Where, int What)
{
	if (Where & 1)
		;
	else	Mapper.Mirror = What;
	Sync();
}

static	void	__cdecl	WriteCD (int Bank, int Where, int What)
{
	if (Where & 1)
		Mapper.IRQlatch = What;
	else	Mapper.IRQcounter = What;
}

static	void	__cdecl	WriteEF (int Bank, int Where, int What)
{
	Mapper.IRQenabled = Where & 1;
}

static	void	__cdecl	UnloadMapper (void)
{
	iNES_UnloadROM();
}

static	void	__cdecl	InitMapper (const PMapperParam _MP, int IsHardReset)
{
	u8 x;
	MP = _MP;

	MP->SetWriteHandler(0x8,Write89);
	MP->SetWriteHandler(0x9,Write89);
	MP->SetWriteHandler(0xA,WriteAB);
	MP->SetWriteHandler(0xB,WriteAB);
	MP->SetWriteHandler(0xC,WriteCD);
	MP->SetWriteHandler(0xD,WriteCD);
	MP->SetWriteHandler(0xE,WriteEF);
	MP->SetWriteHandler(0xF,WriteEF);

	iNES_InitROM();

	for (x = 0; x < 3; x++)	Mapper.PRG[x] = 0xFF;
	for (x = 0; x < 8; x++)Mapper.CHR[x] = x;

	Mapper.IRQenabled = Mapper.IRQcounter = Mapper.IRQlatch = 0;
	Mapper.Cmd = 0;
	Mapper.Mirror = 0;
	Sync();
}

CTMapperInfo	MapperInfo_064 =
{
	"Tengen RAMBO-1",
	64,
	MS_Partial,
	8192,
	InitMapper,
	UnloadMapper,
	HBlank,
	NULL,
	SaveMI,
	LoadMI,
	NULL,
	NULL
};
