#include	"..\DLL\d_iNES.h"

static	struct
{
	u8 IRQenabled, IRQcounter;
	u8 PRG[3];
	u8 CHR[8];
	u8 Mirror;
}	Mapper;

static	void	Sync (void)
{
	u8 x;
	MP->SetPRG_ROM8(0x8,Mapper.PRG[0]);
	MP->SetPRG_ROM8(0xA,Mapper.PRG[1]);
	MP->SetPRG_ROM8(0xC,Mapper.PRG[2]);
	MP->SetPRG_ROM8(0xE,-1);
	for (x = 0; x < 8; x++)
		MP->SetCHR_ROM1(x,Mapper.CHR[x]);
	if (Mapper.Mirror & 0x80)
		MP->Mirror_V();
	else	MP->Mirror_H();
}

static	void	__cdecl	SaveMI (Ar128 MI)
{
	u8 x = 0, i;
	MI[x++] = Mapper.IRQenabled;
	MI[x++] = Mapper.IRQcounter;
for (i = 0; i < 3; i++)	Mapper.PRG[i]	= MI[x++];
for (i = 0; i < 8; i++)	Mapper.CHR[i]	= MI[x++];
	MI[x++] = Mapper.Mirror;
}

static	void	__cdecl	LoadMI (const Ar128 MI)
{
	u8 x = 0, i;
	Mapper.IRQenabled		= MI[x++];
	Mapper.IRQcounter		= MI[x++];
for (i = 0; i < 3; i++) Mapper.PRG[i]	= MI[x++];
for (i = 0; i < 8; i++)	Mapper.CHR[i]	= MI[x++];
	Mapper.Mirror			= MI[x++];
	Sync();
}

static	void	__cdecl	HBlank (int Scanline, int Byte2001)
{
	if (Mapper.IRQenabled)
	{
		if (Mapper.IRQcounter == 0)
		{
			Mapper.IRQenabled = 0;
			MP->IRQ();
		}
		else	Mapper.IRQcounter--;
	}
}

static	void	__cdecl	Write8 (int Bank, int Where, int What)
{
	switch (Where & 7)
	{
	case 0:	Mapper.PRG[0] = What;
		Sync();
		break;
	}
}

static	void	__cdecl	Write9 (int Bank, int Where, int What)
{
	switch (Where & 7)
	{
	case 1:	Mapper.Mirror = What;
		Sync();
		break;
	case 5:	Mapper.IRQcounter = What << 1;		break;
	case 6:	Mapper.IRQenabled = Mapper.IRQcounter;	break;
	}
}

static	void	__cdecl	WriteA (int Bank, int Where, int What)
{
	switch (Where & 7)
	{
	case 0:	Mapper.PRG[1] = What;
		Sync();
		break;
	}
}

static	void	__cdecl	WriteB (int Bank, int Where, int What)
{
	Mapper.CHR[Where & 7] = What;
	Sync();
}

static	void	__cdecl	WriteC (int Bank, int Where, int What)
{
	switch (Where & 7)
	{
	case 0:	Mapper.PRG[2] = What;
		Sync();
		break;
	}
}

static	void	__cdecl	UnloadMapper (void)
{
	iNES_UnloadROM();
}

static	void	__cdecl	InitMapper (const PMapperParam _MP, int IsHardReset)
{
	u8 x;

	MP = _MP;

	MP->SetWriteHandler(0x8,Write8);
	MP->SetWriteHandler(0x9,Write9);
	MP->SetWriteHandler(0xA,WriteA);
	MP->SetWriteHandler(0xB,WriteB);
	MP->SetWriteHandler(0xC,WriteC);

	Mapper.PRG[0] = 0;	Mapper.PRG[1] = 1;	Mapper.PRG[2] = -2;
	for (x = 0; x < 8; x++)
		Mapper.CHR[x] = x;
	Mapper.IRQcounter = Mapper.IRQenabled = 0;
	Sync();

	iNES_InitROM();
}

CTMapperInfo	MapperInfo_065 =
{
	"Irem H-3001",
	65,
	MS_Full,
	8192,
	InitMapper,
	UnloadMapper,
	NULL,
	NULL,
	SaveMI,
	LoadMI,
	NULL,
	NULL
};