#include	"..\DLL\d_iNES.h"

static	struct
{
	u8 Cmd;
	u8 PRG[3];
	u8 CHR[4];
	u8 Mirror;
}	Mapper;

static	void	Sync (void)
{
	u8 x;
	MP->SetPRG_ROM8(0x8,Mapper.PRG[0]);
	MP->SetPRG_ROM8(0xA,Mapper.PRG[1]);
	MP->SetPRG_ROM8(0xC,Mapper.PRG[2]);
	MP->SetPRG_ROM8(0xE,-1);
	for (x = 0; x < 4; x++)
		MP->SetCHR_ROM2(x << 1,Mapper.CHR[x]);
	if (Mapper.Mirror & 1)
		MP->Mirror_H();
	else	MP->Mirror_V();
}

static	void	__cdecl	SaveMI (Ar128 MI)
{
	u8 x = 0, i;
	MI[x++] = Mapper.Mirror;
for (i = 0; i < 3; i++)	MI[x++] = Mapper.PRG[i];
for (i = 0; i < 4; i++)	MI[x++] = Mapper.CHR[i];
}

static	void	__cdecl	LoadMI (const Ar128 MI)
{
	u8 x = 0, i;
	Mapper.Mirror			= MI[x++];
for (i = 0; i < 3; i++)	Mapper.PRG[i]	= MI[x++];
for (i = 0; i < 4; i++)	Mapper.CHR[i]	= MI[x++];
	Sync();
}

static	void	__cdecl	Write89 (int Bank, int Where, int What)
{
	switch (Where & 0x1)
	{
	case 0:	Mapper.Cmd = What;	break;
	case 1:	switch (Mapper.Cmd & 0x07)
		{
		case 2:	Mapper.CHR[0] = What;	break;
		case 3:	Mapper.CHR[1] = What;	break;
		case 4:	Mapper.CHR[2] = What;	break;
		case 5:	Mapper.CHR[3] = What;	break;
		case 6:	if (Mapper.Cmd & 0x40)
				Mapper.PRG[2] = What;
			else	Mapper.PRG[0] = What;
						break;
		case 7:	Mapper.PRG[1] = What;	break;
		}			break;
	}
	Sync();
}

static	void	__cdecl	WriteAB (int Bank, int Where, int What)
{
	switch (Where & 0x1)
	{
	case 0:	Mapper.Mirror = What;	break;
	case 1:				break;
	}
	Sync();
}

static	void	__cdecl	UnloadMapper (void)
{
	iNES_UnloadROM();
}

static	void	__cdecl	InitMapper (const PMapperParam _MP, int IsHardReset)
{
	u8 x;
	MP = _MP;

	MP->SetWriteHandler(0x8,Write89);
	MP->SetWriteHandler(0x9,Write89);
	MP->SetWriteHandler(0xA,WriteAB);
	MP->SetWriteHandler(0xB,WriteAB);

	Mapper.PRG[0] = 0;
	Mapper.PRG[1] = 1;
	Mapper.PRG[2] = -2;
	for (x = 0; x < 4; x++)
		Mapper.CHR[x] = 0;
	Mapper.Cmd = 0;
	Sync();

	iNES_InitROM();
}

CTMapperInfo	MapperInfo_076 =
{
	"Mapper 76",
	76,
	MS_Partial,
	8192,
	InitMapper,
	UnloadMapper,
	NULL,
	NULL,
	SaveMI,
	LoadMI,
	NULL,
	NULL
};