#include	"..\DLL\d_iNES.h"

static	struct
{
	PWriteFunc Write4;
	u8 Latch;
}	Mapper;

static	void	Sync (void)
{
	MP->SetCHR_ROM8(0,Mapper.Latch & 0x7);
	MP->SetPRG_ROM32(0x8,(Mapper.Latch & 0x8) >> 3);
}

static	void	__cdecl	SaveMI (Ar128 MI)
{
	u8 x = 0;
	MI[x++] = Mapper.Latch;
}

static	void	__cdecl	LoadMI (const Ar128 MI)
{
	u8 x = 0;
	Mapper.Latch	= MI[x++];
	Sync();
}

static	void	__cdecl	Write (int Bank, int Where, int What)
{
	if (Where & 0x100)
	{
		Mapper.Latch = What;
		Sync();
	}
	if (Bank == 4) Mapper.Write4(Bank,Where,What);
}

static	void	__cdecl	UnloadMapper (void)
{
	iNES_UnloadROM();
}

static	void	__cdecl	InitMapper (const PMapperParam _MP, int IsHardReset)
{
	MP = _MP;

	Mapper.Write4 = MP->GetWriteHandler(0x4);

	MP->SetWriteHandler(0x4,Write);
	MP->SetWriteHandler(0x5,Write);

	Mapper.Latch = 0;
	Sync();

	iNES_InitROM();
}

CTMapperInfo	MapperInfo_079 =
{
	"NINA-03/NINA-06",
	79,
	MS_Full,
	32768,
	InitMapper,
	UnloadMapper,
	NULL,
	NULL,
	SaveMI,
	LoadMI,
	NULL,
	NULL
};
