#include	"..\DLL\d_iNES.h"

static	struct
{
	u8 PRG[3], CHR[6];
	u8 Mirror;
}	Mapper;

static	void	Sync (void)
{
	MP->SetPRG_ROM8(0x8,Mapper.PRG[0]);
	MP->SetPRG_ROM8(0xA,Mapper.PRG[1]);
	MP->SetPRG_ROM8(0xC,Mapper.PRG[2]);
	MP->SetPRG_ROM8(0xE,-1);
	MP->SetCHR_ROM2(0,Mapper.CHR[0]);
	MP->SetCHR_ROM2(2,Mapper.CHR[1]);
	MP->SetCHR_ROM1(4,Mapper.CHR[2]);
	MP->SetCHR_ROM1(5,Mapper.CHR[3]);
	MP->SetCHR_ROM1(6,Mapper.CHR[4]);
	MP->SetCHR_ROM1(7,Mapper.CHR[5]);
	if (Mapper.Mirror & 1)
		MP->Mirror_H();
	else	MP->Mirror_V();
}

static	void	__cdecl	SaveMI (Ar128 MI)
{
	u8 x = 0, i;
	MI[x++] = Mapper.Mirror;
for (i = 0; i < 3; i++)	MI[x++] = Mapper.PRG[i];
for (i = 0; i < 8; i++)	MI[x++] = Mapper.CHR[i];
}

static	void	__cdecl	LoadMI (const Ar128 MI)
{
	u8 x = 0, i;
	Mapper.Mirror			= MI[x++];
for (i = 0; i < 3; i++)	Mapper.PRG[i]	= MI[x++];
for (i = 0; i < 8; i++)	Mapper.CHR[i]	= MI[x++];
	Sync();
}

static	void	__cdecl	Write (int Bank, int Where, int What)
{
	switch (Where)
	{
	case 0xEF0:	Mapper.CHR[0] = What >> 1;	break;
	case 0xEF1:	Mapper.CHR[1] = What >> 1;	break;
	case 0xEF2:	Mapper.CHR[2] = What;		break;
	case 0xEF3:	Mapper.CHR[3] = What;		break;
	case 0xEF4:	Mapper.CHR[4] = What;		break;
	case 0xEF5:	Mapper.CHR[5] = What;		break;
	case 0xEF6:	Mapper.Mirror = What;		break;
	case 0xEFA:
	case 0xEFB:	Mapper.PRG[0] = What;		break;
	case 0xEFC:
	case 0xEFD:	Mapper.PRG[1] = What;		break;
	case 0xEFE:
	case 0xEFF:	Mapper.PRG[2] = What;		break;
	}
	Sync();
}

static	void	__cdecl	UnloadMapper (void)
{
	iNES_UnloadROM();
}

static	void	__cdecl	InitMapper (const PMapperParam _MP, int IsHardReset)
{
	u8 x;

	MP = _MP;

	MP->SetWriteHandler(0x7,Write);

	iNES_InitROM();

	Mapper.Mirror = 0;
	for (x = 0; x < 8; x++)
		Mapper.CHR[x] = x;

	Mapper.PRG[0] = 0;
	Mapper.PRG[1] = 1;
	Mapper.PRG[2] = -1;
	Sync();
}

CTMapperInfo	MapperInfo_080 =
{
	"Mapper 80",
	80,
	MS_Partial,
	8192,
	InitMapper,
	UnloadMapper,
	NULL,
	NULL,
	SaveMI,
	LoadMI,
	NULL,
	NULL
};