#include	"..\DLL\d_iNES.h"

static	struct
{
	u8 Mirror;
	u8 PRG[4];
	u8 CHR[8];
	u8 Bank;
	u16_n IRQcounter;
}	Mapper;

static	void	Sync (void)
{
	u8 x;
	for (x = 0; x < 4; x++)
		MP->SetPRG_ROM8(8 | (x << 1),Mapper.PRG[x]);
	if (MP->CHR_ROM_Size > 262144)
		for (x = 0; x < 4; x++)
			MP->SetCHR_ROM2(x << 1,Mapper.CHR[(x & 2) ? (x | 6) : (x)]);
	else	for (x = 0; x < 8; x++)
			MP->SetCHR_ROM1(x,Mapper.CHR[x]);
	switch (Mapper.Mirror & 3)
	{
	case 0:	MP->Mirror_V();	break;
	case 1:	MP->Mirror_H();	break;
	case 2:	MP->Mirror_S0();break;
	case 3:	MP->Mirror_S1();break;
	}
}

static	void	__cdecl	SaveMI (Ar128 MI)
{
	u8 x = 0, i;
	MI[x++] = Mapper.Mirror;
for (i = 0; i < 4; i++)	MI[x++] = Mapper.PRG[i];
for (i = 0; i < 8; i++)	MI[x++] = Mapper.CHR[i];
	MI[x++] = Mapper.Bank;
	MI[x++] = Mapper.IRQcounter.b0;
	MI[x++] = Mapper.IRQcounter.b1;
}

static	void	__cdecl	LoadMI (const Ar128 MI)
{
	u8 x = 0, i;
	Mapper.Mirror			= MI[x++];
for (i = 0; i < 4; i++)	Mapper.PRG[i]	= MI[x++];
for (i = 0; i < 8; i++)	Mapper.CHR[i]	= MI[x++];
	Mapper.Bank			= MI[x++];
	Mapper.IRQcounter.b0		= MI[x++];
	Mapper.IRQcounter.b1		= MI[x++];
	Sync();
}

static	void	__cdecl	HBlank (int Scanline, int Byte2001)
{
	if (Mapper.IRQcounter.s0)
	{
		if (Mapper.IRQcounter.s0 < 114)
		{
			Mapper.IRQcounter.s0 = 0;
			MP->IRQ();
		}
		else	Mapper.IRQcounter.s0 -= 114;
	}
}

static	void	__cdecl	Write (int Bank, int Where, int What)
{
	switch (Where & 0x317)
	{
	case 0x000:	Mapper.PRG[0] = ((What << 1) & 0x1E) | 0x0;
			Mapper.PRG[1] = ((What << 1) & 0x1E) | 0x1;	break;
	case 0x100:	Mapper.Mirror = What;		break;
	case 0x200:	Mapper.IRQcounter.b0 = What;	break;
	case 0x201:	Mapper.IRQcounter.b1 = What;	break;
	case 0x300:	Mapper.PRG[0] = What & 0x1F;	break;
	case 0x301:	Mapper.PRG[1] = What & 0x1F;	break;
	case 0x302:	Mapper.PRG[2] = What & 0x1F;	break;
//	case 0x303:	Mapper.PRG[3] = What & 0x1F;	break;
	case 0x310:	Mapper.CHR[0] = What;	break;
	case 0x311:	Mapper.CHR[1] = What;	break;
	case 0x312:	Mapper.CHR[2] = What;	break;
	case 0x313:	Mapper.CHR[3] = What;	break;
	case 0x314:	Mapper.CHR[4] = What;	break;
	case 0x315:	Mapper.CHR[5] = What;	break;
	case 0x316:	Mapper.CHR[6] = What;	break;
	case 0x317:	Mapper.CHR[7] = What;	break;
	}
	Sync();
}

static	void	__cdecl	UnloadMapper (void)
{
	iNES_UnloadROM();
}

static	void	__cdecl	InitMapper (const PMapperParam _MP, int IsHardReset)
{
	u8 x;
	MP = _MP;
	MP->SetWriteHandler(0x8,Write);

	iNES_InitROM();

	Mapper.Mirror = 0;

	for (x = 0; x < 8; x++)
		Mapper.CHR[x] = 0;

	Mapper.PRG[0] = 0x00;
	Mapper.PRG[1] = 0x01;
	Mapper.PRG[2] = 0x1E;
	Mapper.PRG[3] = 0x1F;

	Sync();
}

CTMapperInfo	MapperInfo_083 =
{
	"Cony",
	83,
	MS_Partial,
	8192,
	InitMapper,
	UnloadMapper,
	HBlank,
	NULL,
	SaveMI,
	LoadMI,
	NULL,
	NULL
};