#include	"..\DLL\d_iNES.h"

static	struct
{
	u16_n IRQcounter;
	u8 IRQenabled;
	u8 PRG[4];
	u8 CHR[4];
}	Mapper;

static	void	Sync (void)
{
	u8 x;
	for (x = 0; x < 4; x++)
	{
		MP->SetPRG_ROM8(8 | (x << 1),Mapper.PRG[x]);
		MP->SetCHR_ROM2(0 | (x << 1),Mapper.CHR[x]);
	}
}

static	void	__cdecl	SaveMI (Ar128 MI)
{
	u8 x = 0, i;
for (i = 0; i < 4; i++)	MI[x++] = Mapper.PRG[i];
for (i = 0; i < 4; i++)	MI[x++] = Mapper.CHR[i];
			MI[x++] = Mapper.IRQenabled;
			MI[x++] = Mapper.IRQcounter.b0;
			MI[x++] = Mapper.IRQcounter.b1;
}

static	void	__cdecl	LoadMI (const Ar128 MI)
{
	u8 x = 0, i;
for (i = 0; i < 4; i++)	Mapper.PRG[i]	= MI[x++];
for (i = 0; i < 4; i++)	Mapper.CHR[i]	= MI[x++];
			Mapper.IRQenabled	= MI[x++];
			Mapper.IRQcounter.b0	= MI[x++];
			Mapper.IRQcounter.b1	= MI[x++];
	Sync();
}

static	void	__cdecl	HBlank (int Scanline, int Byte2001)
{
	if (Mapper.IRQenabled)
		Mapper.IRQcounter.s0 += 113;
	if (Mapper.IRQcounter.s0 >= 896)
		MP->IRQ();
}

static	void	__cdecl	Write6 (int Bank, int Where, int What)
{
	Mapper.CHR[Where & 3] = What;
	Sync();
}

static	void	__cdecl	Write7 (int Bank, int Where, int What)
{
	switch (Where & 3)
	{
	case 0:	Mapper.PRG[0] = What & 0xF;	break;
	case 1:	Mapper.PRG[1] = What & 0xF;	break;
	case 2:	Mapper.IRQenabled = 0;
		Mapper.IRQcounter.s0 = 0;	break;
	case 3:	Mapper.IRQenabled = 1;		break;
	}
	Sync();
}

static	void	__cdecl	UnloadMapper (void)
{
	iNES_UnloadROM();
}

static	void	__cdecl	InitMapper (const PMapperParam _MP, int IsHardReset)
{
	MP = _MP;
	MP->SetWriteHandler(0x6,Write6);
	MP->SetWriteHandler(0x7,Write7);

	Mapper.PRG[2] = 0xE;
	Mapper.PRG[3] = 0xF;
	iNES_InitROM();

	Sync();
}

CTMapperInfo	MapperInfo_091 =
{
	"PC-HK-SF3",
	91,
	MS_Partial,
	8192,
	InitMapper,
	UnloadMapper,
	HBlank,
	NULL,
	SaveMI,
	LoadMI,
	NULL,
	NULL
};