#include	"..\DLL\d_iNES.h"

static	struct
{
	u8 Cmd;
	u8 PRG[2], CHR[6];
	u8 Mirror;
}	Mapper;

static	void	Sync (void)
{
	MP->SetPRG_ROM8(0x8,Mapper.PRG[0]);
	MP->SetPRG_ROM8(0xA,Mapper.PRG[1]);

	MP->SetPRG_ROM16(0xC,-1);

	MP->SetCHR_ROM2(0,Mapper.CHR[0] >> 1);
	MP->SetCHR_ROM2(2,Mapper.CHR[1] >> 1);

	MP->SetCHR_ROM1(4,Mapper.CHR[2]);
	MP->SetCHR_ROM1(5,Mapper.CHR[3]);
	MP->SetCHR_ROM1(6,Mapper.CHR[4]);
	MP->SetCHR_ROM1(7,Mapper.CHR[5]);
	if (Mapper.Mirror)
		MP->Mirror_H();
	else	MP->Mirror_V();
}

static	void	__cdecl	SaveMI (Ar128 MI)
{
	u8 x = 0, i;
			MI[x++] = Mapper.Cmd;
for (i = 0; i < 2; i++)	MI[x++] = Mapper.PRG[i];
for (i = 0; i < 6; i++)	MI[x++] = Mapper.CHR[i];
			MI[x++] = Mapper.Mirror;
}

static	void	__cdecl	LoadMI (const Ar128 MI)
{
	u8 x = 0, i;
			Mapper.Cmd	= MI[x++];
for (i = 0; i < 2; i++)	Mapper.PRG[i]	= MI[x++];
for (i = 0; i < 6; i++)	Mapper.CHR[i]	= MI[x++];
			Mapper.Mirror	= MI[x++];
	Sync();
}

static	void	__cdecl	Write89 (int Bank, int Where, int What)
{
	u16 Loc = (Bank << 12) | Where;
	switch (Loc)
	{
	case 0x8000:	Mapper.Cmd = What & 0x07;	break;
	case 0x8001:	Mapper.Mirror = ~What & 1;	break;
	}
	Sync();
}

static	void	__cdecl	WriteAB (int Bank, int Where, int What)
{
	u16 Loc = (Bank << 12) | Where;
	switch (Loc)
	{
	case 0xA000:	switch (Mapper.Cmd)
			{
			case 0:	Mapper.PRG[0] = What;	break;
			case 1:	Mapper.PRG[1] = What;	break;
			case 2:	Mapper.CHR[0] = What;	break;
			case 3:	Mapper.CHR[1] = What;	break;
			case 4:	Mapper.CHR[2] = What;	break;
			case 5:	Mapper.CHR[3] = What;	break;
			case 6:	Mapper.CHR[4] = What;	break;
			case 7:	Mapper.CHR[5] = What;	break;
			}
	}
	Sync();
}

static	void	__cdecl	WriteEF (int Bank, int Where, int What)
{
	u16 Loc = (Bank << 12) | Where;
	switch (Loc)
	{
	case 0xE000:	Mapper.Mirror = What & 1;	break;
	}
	Sync();
}

static	void	__cdecl	UnloadMapper (void)
{
	iNES_UnloadROM();
}

static	void	__cdecl	InitMapper (const PMapperParam _MP, int IsHardReset)
{
	MP = _MP;
	MP->SetWriteHandler(0x8,Write89);
	MP->SetWriteHandler(0x9,Write89);
	MP->SetWriteHandler(0xA,WriteAB);
	MP->SetWriteHandler(0xB,WriteAB);
	MP->SetWriteHandler(0xE,WriteEF);
	MP->SetWriteHandler(0xF,WriteEF);
	Mapper.PRG[0] = 0x00;	Mapper.PRG[1] = 0x01;	Mapper.CHR[0] = 0x00;	Mapper.CHR[1] = 0x01;
	Mapper.CHR[2] = 0x04;	Mapper.CHR[3] = 0x05;	Mapper.CHR[4] = 0x06;	Mapper.CHR[5] = 0x07;
	iNES_InitROM();
	Sync();
}

CTMapperInfo	MapperInfo_112 =
{
	"Mapper 112",
	112,
	MS_Partial,
	8192,
	InitMapper,
	UnloadMapper,
	NULL,
	NULL,
	SaveMI,
	LoadMI,
	NULL,
	NULL
};