#include	"..\DLL\d_iNES.h"

static	struct
{
	u8 PRG, CHR;
	PWriteFunc Write4;
}	Mapper;

static	void	Sync (void)
{
	MP->SetPRG_ROM32(0x8,Mapper.PRG);
	MP->SetCHR_ROM8(0,Mapper.CHR);
}

static	void	__cdecl	SaveMI (Ar128 MI)
{
	u8 x = 0;
	MI[x++] = Mapper.PRG;
	MI[x++] = Mapper.CHR;
}

static	void	__cdecl	LoadMI (const Ar128 MI)
{
	u8 x = 0;
	Mapper.PRG	= MI[x++];
	Mapper.CHR	= MI[x++];
	Sync();
}

static	void	__cdecl	Write (int Bank, int Where, int What)
{
	u16 Loc = (Bank << 12) | Where;
	if (Loc < 0x4018)
	{
		Mapper.Write4(Bank,Where,What);
		return;
	}
	switch (Loc)
	{
	case 0x4120:	Mapper.PRG = (What & 0x38) >> 3;
			Mapper.CHR = (What & 0xC0) >> 3 | (What & 0x07);
			Sync();
			break;
	}
}

static	void	__cdecl	UnloadMapper (void)
{
	iNES_UnloadROM();
}

static	void	__cdecl	InitMapper (const PMapperParam _MP, int IsHardReset)
{
	u8 x;
	MP = _MP;

	Mapper.Write4 = MP->GetWriteHandler(0x4);
	for (x = 0x4; x < 0x8; x++)
		MP->SetWriteHandler(x,Write);

	iNES_InitROM();

	Mapper.PRG = 0;
	Mapper.CHR = 0;
	Sync();
}

CTMapperInfo	MapperInfo_113 =
{
	"Mapper 113 (HES)",
	113,
	MS_Partial,
	32768,
	InitMapper,
	UnloadMapper,
	NULL,
	NULL,
	SaveMI,
	LoadMI,
	NULL,
	NULL
};