#include	"..\DLL\d_iNES.h"
#include	"..\Hardware\h_MMC3.h"

static	void	Sync (void)
{
	MMC3_SyncPRG(0x3F,0);
	MMC3_SyncCHR_ROM(0x7F,0);
}

static	int	__cdecl	TileHandler (int Bank, int TileNum, int Index)
{
	if (MMC3_GetCHRBank((Bank ? 4 : 0) | ((TileNum >> 6) & 0x3)) & 0x80)
		MP->Mirror_S1();
	else	MP->Mirror_S0();
	return 1;
}

static	void	__cdecl	SaveMI (Ar128 MI)
{
	MMC3_SaveMI(MI,0);
}

static	void	__cdecl	LoadMI (const Ar128 MI)
{
	MMC3_LoadMI(MI,0);
}

static	void	__cdecl	UnloadMapper (void)
{
	iNES_UnloadROM();
	MMC3_Destroy();
}

static	void	__cdecl	InitMapper (const PMapperParam _MP, int IsHardReset)
{
	MP = _MP;

	iNES_InitROM();
	MP->SetPRG_RAM8(0x6,0);		/* WRAM for TKSROM */
	MP->Mirror_S0();
	MMC3_Init(Sync);
}

CTMapperInfo	MapperInfo_118 =
{
	"TKSROM/TLSROM (MMC3)",
	118,
	MS_Partial,
	8192,
	InitMapper,
	UnloadMapper,
	MMC3_HBlank,
	TileHandler,
	SaveMI,
	LoadMI,
	NULL,
	NULL
};