#include	"..\DLL\d_iNES.h"

static	struct
{
	u8 PRGcontrol;
	u8 PRG[4];
	u16_n IRQcounter;
	u8 IRQenabled;
}	Mapper;

static	void	Sync (void)
{
	u8 x;
	for (x = 0; x < 3; x++)
		MP->SetPRG_ROM8(8 | (x << 1),Mapper.PRG[x]);
	MP->SetPRG_ROM8(0x6,Mapper.PRG[3]);
	MP->SetPRG_ROM8(0xE,-1);
	MP->SetCHR_RAM8(0,0);
}

static	void	__cdecl	SaveMI (Ar128 MI)
{
	u8 x = 0, i;
			MI[x++] = Mapper.PRGcontrol;
for (i = 0; i < 4; i++)	MI[x++] = Mapper.PRG[i];
			MI[x++] = Mapper.IRQcounter.b0;
			MI[x++] = Mapper.IRQcounter.b1;
			MI[x++] = Mapper.IRQenabled;
}

static	void	__cdecl	LoadMI (const Ar128 MI)
{
	u8 x = 0, i;
			Mapper.PRGcontrol	= MI[x++];
for (i = 0; i < 4; i++)	Mapper.PRG[i]		= MI[x++];
			Mapper.IRQcounter.b0	= MI[x++];
			Mapper.IRQcounter.b1	= MI[x++];
			Mapper.IRQenabled	= MI[x++];
	Sync();
}

static	void	__cdecl	HBlank (int Scanline, int Byte2001)
{
	if (Mapper.IRQenabled)
	{
		if (Mapper.IRQcounter.s0 > (0xFFFF - 113))
		{
			Mapper.IRQenabled = 0;
			MP->IRQ();
		}
		else	Mapper.IRQcounter.s0 += 113;
	}
}

static	void	__cdecl	Write8 (int Bank, int Where, int What)
{
	Mapper.IRQcounter.n0 = What & 0xF;
}

static	void	__cdecl	Write9 (int Bank, int Where, int What)
{
	Mapper.IRQcounter.n1 = What & 0xF;
}

static	void	__cdecl	WriteA (int Bank, int Where, int What)
{
	Mapper.IRQcounter.n2 = What & 0xF;
}

static	void	__cdecl	WriteB (int Bank, int Where, int What)
{
	Mapper.IRQcounter.n3 = What & 0xF;
}

static	void	__cdecl	WriteC (int Bank, int Where, int What)
{
	Mapper.IRQenabled = What & 0xF;
}

static	void	__cdecl	WriteE (int Bank, int Where, int What)
{
	Mapper.PRGcontrol = What & 0xF;
}

static	void	__cdecl	WriteF (int Bank, int Where, int What)
{
	switch (Mapper.PRGcontrol)
	{
	case 0x1:	Mapper.PRG[0] = What & 0xF;	break;
	case 0x2:	Mapper.PRG[1] = What & 0xF;	break;
	case 0x3:	Mapper.PRG[2] = What & 0xF;	break;
	case 0x4:	Mapper.PRG[3] = What & 0xF;	break;
	}
	Sync();
}

static	void	__cdecl	UnloadMapper (void)
{
	iNES_UnloadROM();
}

static	void	__cdecl	InitMapper (const PMapperParam _MP, int IsHardReset)
{
	u8 x;

	MP = _MP;
	MP->SetWriteHandler(0x8,Write8);
	MP->SetWriteHandler(0x9,Write9);
	MP->SetWriteHandler(0xA,WriteA);
	MP->SetWriteHandler(0xB,WriteB);
	MP->SetWriteHandler(0xC,WriteC);
	MP->SetWriteHandler(0xE,WriteE);
	MP->SetWriteHandler(0xF,WriteF);

	iNES_InitROM();

	for (x = 0; x < 4; x++)
		Mapper.PRG[x] = 0;
	Mapper.PRGcontrol = 0;
	Sync();
}

CTMapperInfo	MapperInfo_142 =
{
	"SMB2j Pirate (KS 202)",
	142,
	MS_Full,
	8192,
	InitMapper,
	UnloadMapper,
	HBlank,
	NULL,
	SaveMI,
	LoadMI,
	NULL,
	NULL
};