#include	"..\DLL\d_iNES.h"

static	struct
{
	u8 PRG[3], CHR[2];
}	Mapper;

static	void	Sync (void)
{
	MP->SetPRG_ROM8(0x8,Mapper.PRG[0]);
	MP->SetPRG_ROM8(0xA,Mapper.PRG[1]);
	MP->SetPRG_ROM8(0xC,Mapper.PRG[2]);
	MP->SetPRG_ROM8(0xE,-1);
	MP->SetCHR_ROM4(0,Mapper.CHR[0]);
	MP->SetCHR_ROM4(4,Mapper.CHR[1]);
}

static	void	__cdecl	SaveMI (Ar128 MI)
{
	u8 x = 0, i;
for (i = 0; i < 3; i++)	MI[x++] = Mapper.PRG[i];
for (i = 0; i < 2; i++)	MI[x++] = Mapper.CHR[i];
}

static	void	__cdecl	LoadMI (const Ar128 MI)
{
	u8 x = 0, i;
for (i = 0; i < 3; i++)	Mapper.PRG[i] = MI[x++];
for (i = 0; i < 2; i++)	Mapper.CHR[i] = MI[x++];
	Sync();
}

static	void	__cdecl	Write8 (int Bank, int Where, int What)
{
	Mapper.PRG[0] = What;
	Sync();
}

static	void	__cdecl	WriteA (int Bank, int Where, int What)
{
	Mapper.PRG[1] = What;
	Sync();
}

static	void	__cdecl	WriteC (int Bank, int Where, int What)
{
	Mapper.PRG[2] = What;
	Sync();
}

static	void	__cdecl	WriteE (int Bank, int Where, int What)
{
	Mapper.CHR[0] = What;
	Sync();
}

static	void	__cdecl	WriteF (int Bank, int Where, int What)
{
	Mapper.CHR[1] = What;
	Sync();
}

static	void	__cdecl	UnloadMapper (void)
{
	iNES_UnloadROM();
}

static	void	__cdecl	InitMapper (const PMapperParam _MP, int IsHardReset)
{
	MP = _MP;

	MP->SetWriteHandler(0x8,Write8);
	MP->SetWriteHandler(0xA,WriteA);
	MP->SetWriteHandler(0xC,WriteC);
	MP->SetWriteHandler(0xE,WriteE);
	MP->SetWriteHandler(0xF,WriteF);

	iNES_InitROM();

	Mapper.PRG[0] = 0;
	Mapper.PRG[1] = 1;
	Mapper.PRG[2] = -2;
	Mapper.CHR[0] = 0;
	Mapper.CHR[1] = 1;
	Sync();
}

CTMapperInfo	MapperInfo_151 =
{
	"Extended VS Unisystem",
	151,
	MS_Partial,
	8192,
	InitMapper,
	UnloadMapper,
	NULL,
	NULL,
	SaveMI,
	LoadMI,
	NULL,
	NULL
};