#include	"..\DLL\d_iNES.h"

static	struct
{
	u8 Cmd;
	u8 IRQenabled, IRQcounter;
}	Mapper;

static	void	__cdecl	SaveMI (Ar128 MI)
{
	u8 x = 0;
	MI[x++] = Mapper.Cmd;
	MI[x++] = Mapper.IRQenabled;
	MI[x++] = Mapper.IRQcounter;
}

static	void	__cdecl	LoadMI (const Ar128 MI)
{
	u8 x = 0;
	Mapper.Cmd		= MI[x++];
	Mapper.IRQenabled	= MI[x++];
	Mapper.IRQcounter	= MI[x++];
}

static	void	__cdecl	HBlank (int Scanline, int Byte2001)
{
	if ((Mapper.IRQenabled) && (Scanline < 240) && (Byte2001 & 0x18))
	{
		Mapper.IRQcounter--;
		if (Mapper.IRQcounter == 0)
		{
			Mapper.IRQenabled = 0;
			MP->IRQ();
		}
	}
}

static	void	__cdecl	Write89 (int Bank, int Where, int What)
{
	if (What & 1)
		MP->Mirror_H();
	else	MP->Mirror_V();
}

static	void	__cdecl	WriteAB (int Bank, int Where, int What)
{
	Mapper.Cmd = What;
}

static	void	__cdecl	WriteCD (int Bank, int Where, int What)
{
	switch (Mapper.Cmd)
	{
	case 0:	MP->SetCHR_ROM2(0,What >> 1);	break;
	case 1:	MP->SetCHR_ROM1(5,What);	break;
	case 2:	MP->SetCHR_ROM2(2,What >> 1);	break;
	case 3:	MP->SetCHR_ROM1(7,What);	break;
	case 4:	MP->SetPRG_ROM8(0x8,What);	break;
	case 5:	MP->SetPRG_ROM8(0xA,What);	break;
	case 6:	MP->SetCHR_ROM1(4,What);	break;
	case 7:	MP->SetCHR_ROM1(6,What);	break;
	}
}

static	void	__cdecl	WriteEF (int Bank, int Where, int What)
{
	Mapper.IRQcounter = What;
	Mapper.IRQenabled = What;
}

static	void	__cdecl	UnloadMapper (void)
{
	iNES_UnloadROM();
}

static	void	__cdecl	InitMapper (const PMapperParam _MP, int IsHardReset)
{
	MP = _MP;

	MP->SetWriteHandler(0x8,Write89);
	MP->SetWriteHandler(0x9,Write89);
	MP->SetWriteHandler(0xA,WriteAB);
	MP->SetWriteHandler(0xB,WriteAB);
	MP->SetWriteHandler(0xC,WriteCD);
	MP->SetWriteHandler(0xD,WriteCD);
	MP->SetWriteHandler(0xE,WriteEF);
	MP->SetWriteHandler(0xF,WriteEF);

	MP->SetPRG_ROM32(0x8,-1);
	MP->SetCHR_ROM8(0,0);

	iNES_InitROM();

	Mapper.IRQcounter = Mapper.IRQenabled = 0;
	Mapper.Cmd = 0;
}

CTMapperInfo	MapperInfo_182 =
{
	"Super Donkey Kong",
	182,
	MS_Full,
	8192,
	InitMapper,
	UnloadMapper,
	HBlank,
	NULL,
	SaveMI,
	LoadMI,
	NULL,
	NULL
};
