#include	"..\DLL\d_iNES.h"
#include	<stdlib.h>

static	struct
{
	u8 Init;
	u8 *VRAM[8];
}	Mapper = {0};

static	void	__cdecl	Write (int Bank, int Where, int What)
{
	u8 x;
	u16 i;
	u8 *CHR;
	if (What & 0x02)
		for (x = 0; x < 8; x++)
			memcpy(MP->GetCHR_Ptr1(x),Mapper.VRAM[x],1024);
	else	for (x = 0; x < 8; x++)
		{
			CHR = MP->GetCHR_Ptr1(x);
			for (i = 0; i < 0x400; i++)
				CHR[i] = ~Mapper.VRAM[x][i];
		}
	MP->SetCHR_ROM8(0,0);
}

static	void	__cdecl	UnloadMapper (void)
{
	Mapper.Init = 0;
	iNES_UnloadROM();
}

static	void	__cdecl	InitMapper (const PMapperParam _MP, int IsHardReset)
{
	u8 x;

	MP = _MP;

	for (x = 0x8; x < 0x10; x++)
		MP->SetWriteHandler(x,Write);

	MP->SetPRG_ROM16(0x8,0);
	MP->SetPRG_ROM16(0xC,1);

	MP->SetCHR_RAM8(0,0);

	for (x = 0; x < 8; x++)
		Mapper.VRAM[x] = MP->GetCHR_Ptr1(x);	/* figure out where CHR_RAM is */

	MP->SetCHR_ROM8(0,0);

	if (Mapper.Init == 0)
	{
		for (x = 0; x < 8; x++)
			memcpy(Mapper.VRAM[x],MP->GetCHR_Ptr1(x),1024);
		Mapper.Init = 1;
	}

	iNES_InitROM();
}

CTMapperInfo	MapperInfo_185 =
{
	"Mapper 185",
	185,
	MS_Partial,
	32768,
	InitMapper,
	UnloadMapper,
	NULL,
	NULL,
	NULL,
	NULL,
	NULL,
	NULL
};