#include	"..\DLL\d_iNES.h"
#include	"..\Hardware\h_74xx.h"

static	void	Sync (void)
{
	union
	{
		struct
		{
			unsigned PRGsize : 1;
			unsigned Mir_HV  : 1;
			unsigned PRG16   : 1;
			unsigned PRGbank : 4;
			unsigned CHRprot : 1;
			unsigned PRGchip : 1;
			unsigned LastBank: 1;
			unsigned         : 9;
		};
		struct
		{
			unsigned n       :16;
		};
	}	Addr;
	Addr.n = _74xx.Addr;

	MP->SetCHR_RAM8(0,0);

	if (Addr.Mir_HV)
		MP->Mirror_H();
	else	MP->Mirror_V();
	if (!Addr.PRGsize) 
	{
		MP->SetPRG_ROM16(0x8,(Addr.PRGchip << 5) | (Addr.PRGbank << 1) | (Addr.PRG16));
		MP->SetPRG_ROM16(0xC,(Addr.PRGchip << 5) | (Addr.PRGbank << 1) | (Addr.PRG16));
	}
	else	MP->SetPRG_ROM32(0x8,(Addr.PRGchip << 4) | (Addr.PRGbank));

	if (Addr.CHRprot)
		;	/* Protect CHR */
	else
	{	/* Unprotect CHR */
		if (Addr.LastBank)
			MP->SetPRG_ROM16(0xC,(Addr.PRGchip << 5) | (Addr.PRGbank << 1) |  7);
		else	MP->SetPRG_ROM16(0xC,(Addr.PRGchip << 5) | (Addr.PRGbank << 1) & ~7);
	}
}

static	void	__cdecl	SaveMI (Ar128 MI)
{
	_74xx_SaveMI_A(MI,0);
}

static	void	__cdecl	LoadMI (const Ar128 MI)
{
	_74xx_LoadMI_A(MI,0);
}

static	void	__cdecl	UnloadMapper (void)
{
	iNES_UnloadROM();
	_74xx_Destroy();
}

static	void	__cdecl	InitMapper (const PMapperParam _MP, int IsHardReset)
{
	MP = _MP;
	_74xx_Init(Sync,IsHardReset,FALSE);
	iNES_InitROM();
}

CTMapperInfo	MapperInfo_227 =
{
	"1200-in-1",
	227,
	MS_Full,
	32768,
	InitMapper,
	UnloadMapper,
	NULL,
	NULL,
	SaveMI,
	LoadMI,
	NULL,
	NULL
};