#include	"..\DLL\d_iNES.h"

static	struct
{
	int WhichGame;
	int WhichBank;
}	Mapper;

static	void	__cdecl	SaveMI (Ar128 MI)
{
	u8 x = 0;
	MI[x++] = Mapper.WhichGame;
	MI[x++] = Mapper.WhichBank;
}

static	void	__cdecl	LoadMI (const Ar128 MI)
{
	u8 x = 0;
	Mapper.WhichGame	= MI[x++];
	Mapper.WhichBank	= MI[x++];
}

static	void	SyncPRG (void)
{
	MP->SetPRG_ROM16(0x8,Mapper.WhichGame | Mapper.WhichBank);
	MP->SetPRG_ROM16(0xC,Mapper.WhichGame | 3);
}

static	void	__cdecl	Write9 (int Bank, int Where, int What)
{
	Mapper.WhichGame = (What & 0x18) >> 1;
	SyncPRG();
}

static	void	__cdecl	WriteABCDEF (int Bank, int Where, int What)
{
	Mapper.WhichBank = What & 3;
	SyncPRG();
}

static	void	__cdecl	UnloadMapper (void)
{
	iNES_UnloadROM();
}

static	void	__cdecl	InitMapper (const PMapperParam _MP, int IsHardReset)
{
	MP = _MP;

	MP->SetWriteHandler(0x9,Write9);
	MP->SetWriteHandler(0xA,WriteABCDEF);
	MP->SetWriteHandler(0xB,WriteABCDEF);
	MP->SetWriteHandler(0xC,WriteABCDEF);
	MP->SetWriteHandler(0xD,WriteABCDEF);
	MP->SetWriteHandler(0xE,WriteABCDEF);
	MP->SetWriteHandler(0xF,WriteABCDEF);

	MP->SetCHR_RAM8(0,0);

	iNES_InitROM();

	Mapper.WhichGame = 0;
	Mapper.WhichBank = 3;

	SyncPRG();
}

CTMapperInfo	MapperInfo_232 =
{
	"Camerica 9096",
	232,
	MS_Nearly,
	16384,
	InitMapper,
	UnloadMapper,
	NULL,
	NULL,
	SaveMI,
	LoadMI,
	NULL,
	NULL
};