#include	"..\DLL\d_iNES.h"

static	struct
{
	PReadFunc Read6;
	PWriteFunc Write6;
}	Mapper;

static	int	__cdecl	Read6 (int Bank, int Where)
{
	if (Where > 0x7FF)
		return Mapper.Read6(Bank,Where);
	else	return 0;
}

static	void	__cdecl	Write6 (int Bank, int Where, int What)
{
	if (Where > 0x7FF)
	{
		Mapper.Write6(Bank,Where,What);
		return;
	}
	switch (Where & 0x007)
	{
	case 0:	MP->SetPRG_ROM8(0x8,What);	break;
	case 1:	MP->SetPRG_ROM8(0xA,What);	break;
	case 2:	MP->SetPRG_ROM8(0xC,What);	break;
	case 3:	MP->SetPRG_ROM8(0xE,What);	break;
	case 4:	MP->SetCHR_ROM2(0,What);	break;
	case 5:	MP->SetCHR_ROM2(2,What);	break;
	case 6:	MP->SetCHR_ROM2(4,What);	break;
	case 7:	MP->SetCHR_ROM2(6,What);	break;
	}
}

static	void	__cdecl	UnloadMapper (void)
{
	iNES_UnloadROM();
}

static	void	__cdecl	InitMapper (const PMapperParam _MP, int IsHardReset)
{
	MP = _MP;

	Mapper.Read6 = MP->GetReadHandler(0x6);
	Mapper.Write6 = MP->GetWriteHandler(0x6);
	MP->SetReadHandler(0x6,Read6);
	MP->SetWriteHandler(0x6,Write6);

	MP->SetPRG_ROM16(0x8,0);
	MP->SetPRG_ROM16(0xC,-1);
	MP->SetCHR_ROM8(0,0);

	iNES_InitROM();
}

CTMapperInfo	MapperInfo_246 =
{
	"Mapper 246",
	246,
	MS_Partial,
	8192,
	InitMapper,
	UnloadMapper,
	NULL,
	NULL,
	NULL,
	NULL,
	NULL,
	NULL
};