/*
 * NESten Mapper Interface v2.1
 */

#ifndef	WIN32_LEAN_AND_MEAN
#define	WIN32_LEAN_AND_MEAN
#endif

/* So this file only gets included once */

#ifndef	__INTERFACE_H__
#define	__INTERFACE_H__

/* Standard header files, used by all mappers */

#include	<windows.h>

#define	MSGBOX_FLAGS	(MB_OK | MB_ICONERROR | MB_DEFBUTTON1 | MB_APPLMODAL)

/* Mapper Interface version (2.1) */

#define	CurrentMapperInterface 0x00020001

/* Integer types */

typedef	signed __int8		s8;
typedef	signed __int16		s16;
typedef	signed __int32		s32;
typedef	signed __int64		s64;

typedef	unsigned __int8		u8;
typedef	unsigned __int16	u16;
typedef	unsigned __int32	u32;
typedef	unsigned __int64	u64;

typedef	union
{
	struct
	{
		unsigned n0 : 4;
		unsigned n1 : 4;
	};
	struct
	{
		unsigned b0 : 8;
	};
}	u8_n;

typedef	union
{
	struct
	{
		unsigned n0 : 4;
		unsigned n1 : 4;
		unsigned n2 : 4;
		unsigned n3 : 4;
	};
	struct
	{
		unsigned b0 : 8;
		unsigned b1 : 8;
	};
	struct
	{
		unsigned s0 :16;
	};
}	u16_n;

typedef	union
{
	struct
	{
		unsigned n0 : 4;
		unsigned n1 : 4;
		unsigned n2 : 4;
		unsigned n3 : 4;
		unsigned n4 : 4;
		unsigned n5 : 4;
		unsigned n6 : 4;
		unsigned n7 : 4;
	};
	struct
	{
		unsigned b0 : 8;
		unsigned b1 : 8;
		unsigned b2 : 8;
		unsigned b3 : 8;
	};
	struct
	{
		unsigned s0 :16;
		unsigned s1 :16;
	};
	struct
	{
		unsigned l0 :32;
	};
}	u32_n;

/* Function types */

typedef	void	(__cdecl *PWriteFunc)	(int,int,int);
typedef	int	(__cdecl *PReadFunc)	(int,int);

/* The Mapper Interface Structure - Pointers to data and functions within NESten */

typedef	struct	MapperParam
{
	/* .NES Header information */
		int		Flags;			/* Mapper flags */
		int		PRG_ROM_Size;		/* PRG_ROM size in bytes */
		int		CHR_ROM_Size;		/* CHR_ROM size in bytes */
		int		Unused;

	/* Functions for managing read/write handlers */
		void		(__cdecl *SetWriteHandler)	(int,PWriteFunc);
		void		(__cdecl *SetReadHandler)	(int,PReadFunc);
		PWriteFunc	(__cdecl *GetWriteHandler)	(int);
		PReadFunc	(__cdecl *GetReadHandler)	(int);

	/* Functions for mapping PRG */
		void		(__cdecl *SetPRG_ROM4)		(int,int);
		void		(__cdecl *SetPRG_ROM8)		(int,int);
		void		(__cdecl *SetPRG_ROM16)		(int,int);
		void		(__cdecl *SetPRG_ROM32)		(int,int);
		int		(__cdecl *GetPRG_ROM4)		(int);		/* -1 if no ROM mapped */
#define		GetPRG_ROM8(x)	GetPRG_ROM4(x) >> 1
#define		GetPRG_ROM16(x)	GetPRG_ROM4(x) >> 2
		void		(__cdecl *SetPRG_RAM4)		(int,int);
		void		(__cdecl *SetPRG_RAM8)		(int,int);
		void		(__cdecl *SetPRG_RAM16)		(int,int);
		void		(__cdecl *SetPRG_RAM32)		(int,int);
		int		(__cdecl *GetPRG_RAM4)		(int);		/* -1 if no RAM mapped */
#define		GetPRG_RAM8(x)	GetPRG_RAM4(x) >> 1
		char *		(__cdecl *GetPRG_Ptr4)		(int);
		
		void		(__cdecl *SetPRG_OB4)		(int);		/* Open bus */

	/* Functions for mapping CHR */
		void		(__cdecl *SetCHR_ROM1)		(int,int);
		void		(__cdecl *SetCHR_ROM2)		(int,int);
		void		(__cdecl *SetCHR_ROM4)		(int,int);
		void		(__cdecl *SetCHR_ROM8)		(int,int);
		int		(__cdecl *GetCHR_ROM1)		(int);		/* -1 if no ROM mapped */

		void		(__cdecl *SetCHR_RAM1)		(int,int);
		void		(__cdecl *SetCHR_RAM2)		(int,int);
		void		(__cdecl *SetCHR_RAM4)		(int,int);
		void		(__cdecl *SetCHR_RAM8)		(int,int);
		int		(__cdecl *GetCHR_RAM1)		(int);		/* -1 if no RAM mapped */
		
		char *		(__cdecl *GetCHR_Ptr1)		(int);
/*		void		(__cdecl *SetCHR_OB1)		(int);		/* Open bus */

	/* Functions for controlling mirroring */
		void		(__cdecl *Mirror_H)		(void);
		void		(__cdecl *Mirror_V)		(void);
		void		(__cdecl *Mirror_4)		(void);
		void		(__cdecl *Mirror_S0)		(void);
		void		(__cdecl *Mirror_S1)		(void);
		void		(__cdecl *Mirror_Custom)	(int,int,int,int);

	/* IRQ */
		void		(__cdecl *IRQ)			(void);

	/* Save RAM Handling */
		void		(__cdecl *Set_SRAMSize)		(int);		/* Sets the size of the SRAM (in bytes) */
		void		(__cdecl *Save_SRAM)		(void);		/* Saves SRAM to disk */
		void		(__cdecl *Load_SRAM)		(void);		/* Loads SRAM from disk */

	/* Misc Callbacks */
		void		(__cdecl *DbgOut)		(char *);	/* Echo text to debug window */
		void		(__cdecl *StatusOut)		(char *);	/* Echo text on status bar */
		int		(__cdecl *GetMenuRoot)		(void);		/* Gets root menu */
		int		(__cdecl *AddMenuItem)		(int,char *,int,int,int,int,int);
										/* Adds menu item, returns menu handle (for submenus) */
	/* Special Chip functions */
	/* MMC5 */
		void		(__cdecl *MMC5_UpdateAttributeCache)
								(void);		/* Update attribute cache for ExRAM gfx mode */
}	TMapperParam, *PMapperParam;

extern PMapperParam MP;

typedef	u8	Ar128[128];

#define		MS_None		0
#define		MS_Partial	1
#define		MS_Nearly	2
#define		MS_Full		3

#define		MENU_NOCHECK	0
#define		MENU_UNCHECKED	1
#define		MENU_CHECKED	2

/* Mapper Information structure - Contains pointers to mapper functions, sent to NESten on load mapper  */

typedef	struct	MapperInfo
{
	/* Mapper Information */
		char *		BoardName;
		int		MapperNum;
		int		MapperSupport;
		int		BankSize;

	/* Mapper Functions */
		void		(__cdecl *InitMapper)	(const PMapperParam,int);
		void		(__cdecl *UnloadMapper)	(void);
		void		(__cdecl *HBlank)	(int,int);
		int		(__cdecl *TileHandler)	(int,int,int);
		void		(__cdecl *SaveMI)	(Ar128);
		void		(__cdecl *LoadMI)	(const Ar128);
		void		(__cdecl *MapperSnd)	(s16 *,int);
		void		(__cdecl *MenuClick)	(int,int,int,int);
}	TMapperInfo, *PMapperInfo;
typedef	const	TMapperInfo	CTMapperInfo, *CPMapperInfo;

/* DLL Information Structure:- Contains general information about the mapper DLL */

typedef	struct	DLLInfo
{
		char *		Author;
		int		Date;
		int		Version;
		CPMapperInfo	(__cdecl *LoadMapper)	(int);
		CPMapperInfo	(__cdecl *LoadBoard)	(char *);
}	TDLLInfo, *PDLLInfo;

#endif	/* __INTERFACE_H__ */