#ifndef	__SND_FME07_H__
#define	__SND_FME07_H__

#define	NES_INC_SIZE_INT (204800000 / 77)

typedef	struct	FME07sqr
{
	union
	{
		struct
		{
			unsigned freq    :12;
			unsigned         : 4;
			unsigned volume  : 4;
			unsigned envmode : 1;
			unsigned         : 3;
		};
		struct
		{
			unsigned byte0 : 8;
			unsigned byte1 : 8;
			unsigned byte2 : 8;
		};
	};
	u8 CurP;
	s64 LCtr;
}	TFME07sqr, *PFME07sqr;

typedef	struct	FME07noise
{
	union
	{
		struct
		{
			unsigned freq  : 5;
			unsigned       : 3;
		};
		struct
		{
			unsigned byte0 : 8;
		};
	};
	u16_n ShiftReg;
	s64 LCtr;
}	TFME07noise, *PFME07noise;

typedef	struct	FME07sound
{
	union
	{
		struct
		{
			unsigned tone      : 3;
			unsigned noise     : 3;
			unsigned           : 2;
			unsigned envelope  :16;
			unsigned envhold   : 1;
			unsigned envaltr   : 1;
			unsigned envattk   : 1;
			unsigned envcont   : 1;
			unsigned           : 4;
		};
		struct
		{
			unsigned byte7 : 8;
			unsigned byteB : 8;
			unsigned byteC : 8;
			unsigned byteD : 8;
		};
	};
	u8 select;
	TFME07sqr Sqr[3];
	TFME07noise Noise;
}	TFME07sound, *PFME07sound;

void	FME07sound_Init (void);
void	FME07sound_Write (int,int);
void	FME07sound_Get (s16 *,int);
int	FME07sound_SaveMI (Ar128,int);
int	FME07sound_LoadMI (const Ar128,int);
void	FME07sound_Destroy (void);

#endif	/* __SND_FME07_H__ */