#ifndef	__SND_MMC5_H__
#define	__SND_MMC5_H__

#define	NES_INC_SIZE_INT	(204800000 / 77)
#define	DLAY_CONST_INT		(65536000 / 60)
#define	NUM_MS_FRAME_INT	(65536000 / 44100)
#define	QUARTER_VBLANK_INT	(65536000 / 240)

typedef	struct	MMC5Sqr
{
	union
	{
		struct
		{
			unsigned volume  : 4;
			unsigned envelope: 1;
			unsigned wavehold: 1;
			unsigned duty    : 2;

			unsigned         : 8;

			unsigned freq    :11;
			unsigned length  : 5;
		};
		struct
		{
			unsigned byte0   : 8;
			unsigned         : 8;
			unsigned byte2   : 8;
			unsigned byte3   : 8;
		};
	};
	u8 CurD;
	s64 LCtr;
	int Timer;
	int EnvCtr, Envelope;
	u8 Enabled;
}	TMMC5sqr, *PMMC5sqr;

typedef	struct	MMC5sound
{
	TMMC5sqr Sqr0, Sqr1;
}	TMMC5sound, *PMMC5sound;

void	MMC5sound_Init (void);
void	MMC5sound_Write (int,int);
void	MMC5sound_Get (s16 *,int);
int	MMC5sound_SaveMI (Ar128,int);
int	MMC5sound_LoadMI (const Ar128,int);
void	MMC5sound_Destroy (void);

#endif	/* __SND_MMC5_H__ */