#ifndef	__SND_VRC6_H_
#define	__SND_VRC6_H_

#define	NES_INC_SIZE_INT (204800000 / 77)

typedef	struct	VRC6sqr
{
	union
	{
		struct
		{
			unsigned volume	: 4;
			unsigned duty	: 3;
			unsigned digital: 1;
			unsigned freq	:12;
			unsigned	: 3;
			unsigned enabled: 1;
			unsigned	: 8;
		};
		struct
		{
			unsigned byte0	: 8;
			unsigned byte1	: 8;
			unsigned byte2	: 8;
			unsigned	: 8;
		};
	};
	u8 CurP;
	s64 LCtr;
}	TVRC6sqr, *PVRC6sqr;

typedef	struct	VRC6saw
{
	union
	{
		struct
		{
			unsigned volume	: 6;
			unsigned 	: 2;
			unsigned freq	:12;
			unsigned	: 3;
			unsigned enabled: 1;
			unsigned	: 8;
		};
		struct
		{
			unsigned byte0	: 8;
			unsigned byte1	: 8;
			unsigned byte2	: 8;
			unsigned	: 8;
		};
	};
	u8 CurP;
	u8 Acc;
	s64 LCtr;
}	TVRC6saw, *PVRC6saw;

typedef	struct	VRC6sound
{
	TVRC6sqr Sqr[2];
	TVRC6saw Saw;
}	TVRC6sound, *PVRC6sound;

void	VRC6sound_Init (void);
void	VRC6sound_Write (int,int);
void	VRC6sound_Get (s16 *,int);
int	VRC6sound_SaveMI (Ar128,int);
int	VRC6sound_LoadMI (const Ar128,int);
void	VRC6sound_Destroy (void);

#endif	/* __SND_VRC6_H__ */
