#include	"h_74xx.h"

T_74xx	_74xx;

void	_74xx_Init (void (*Sync)(void), BOOL Reset, BOOL BusConflicts)
{
	u8 x;
	for (x = 0x8; x <= 0xF; x++)
		MP->SetWriteHandler(x,_74xx_Write);
	if (Reset)
	{
		_74xx.Data = 0;
		_74xx.Addr = 0;
	}
	_74xx.BusConflicts = BusConflicts;
	(_74xx.Sync = Sync)();
}

void	_74xx_Destroy (void)
{
}

int	_74xx_SaveMI_AD (Ar128 MI, int x)
{
	MI[x++] = _74xx.AddrL;
	MI[x++] = _74xx.AddrH;
	MI[x++] = _74xx.Data;
	return x;
}
int	_74xx_LoadMI_AD (const Ar128 MI, int x)
{
	_74xx.AddrL	= MI[x++];
	_74xx.AddrH	= MI[x++];
	_74xx.Data	= MI[x++];
	_74xx.Sync();
	return x;
}

int	_74xx_SaveMI_AL (Ar128 MI, int x)
{
	MI[x++] = _74xx.AddrL;
	return x;
}
int	_74xx_LoadMI_AL (const Ar128 MI, int x)
{
	_74xx.AddrL	= MI[x++];
	_74xx.Sync();
	return x;
}

int	_74xx_SaveMI_A (Ar128 MI, int x)
{
	MI[x++] = _74xx.AddrL;
	MI[x++] = _74xx.AddrH;
	return x;
}
int	_74xx_LoadMI_A (const Ar128 MI, int x)
{
	_74xx.AddrL	= MI[x++];
	_74xx.AddrH	= MI[x++];
	_74xx.Sync();
	return x;
}

int	_74xx_SaveMI_D (Ar128 MI, int x)
{
	MI[x++] = _74xx.Data;
	return x;
}
int	_74xx_LoadMI_D (const Ar128 MI, int x)
{
	_74xx.Data	= MI[x++];
	_74xx.Sync();
	return x;
}

void	__cdecl	_74xx_Write (int Bank, int Where, int What)
{
#ifdef BUS_CONFLICTS
	if ((_74xx.BusConflicts) && (MP->GetReadHandler(Bank)(Bank,Where) != What))
	{
		MP->DbgOut("Bus conflict!");
		return;
	}
#endif
	_74xx.Data = What;
	_74xx.Addr = (Bank << 12) | Where;
	_74xx.Sync();
}