#include	"h_MMC2.h"

static	TMMC2	MMC2;

void	MMC2_Init (void (*Sync)(void))
{
	u8 x;
	for (x = 0; x < 2; x++)
	{
		MMC2.LatchState[x] = 0xFE;
		MMC2.Latch0[x] = 0;
		MMC2.Latch1[x] = 0;
	}
	MP->SetWriteHandler(0xA,MMC2_WriteA);
	MP->SetWriteHandler(0xB,MMC2_WriteB);
	MP->SetWriteHandler(0xC,MMC2_WriteC);
	MP->SetWriteHandler(0xD,MMC2_WriteD);
	MP->SetWriteHandler(0xE,MMC2_WriteE);
	MP->SetWriteHandler(0xF,MMC2_WriteF);
	(MMC2.Sync = Sync)();
}

void	MMC2_Destroy (void)
{
}

int	MMC2_SaveMI (Ar128 MI, int x)
{
	MI[x++] = MMC2.LatchState[0];
	MI[x++] = MMC2.LatchState[1];
	MI[x++] = MMC2.Latch0[0];
	MI[x++] = MMC2.Latch0[1];
	MI[x++] = MMC2.Latch1[0];
	MI[x++] = MMC2.Latch1[1];
	MI[x++] = MMC2.PRG;
	MI[x++] = MMC2.Mirror;
	return x;
}

int	MMC2_LoadMI (const Ar128 MI, int x)
{
	MMC2.LatchState[0]	= MI[x++];
	MMC2.LatchState[1]	= MI[x++];
	MMC2.Latch0[0]		= MI[x++];
	MMC2.Latch0[1]		= MI[x++];
	MMC2.Latch1[0]		= MI[x++];
	MMC2.Latch1[1]		= MI[x++];
	MMC2.PRG		= MI[x++];
	MMC2.Mirror		= MI[x++];
	return x;
}

void	MMC2_SyncPRG (int AND, int OR)
{
	MP->SetPRG_ROM8(0x8,(MMC2.PRG & AND) | OR);
	MP->SetPRG_ROM8(0xA,(~2 & AND) | OR);
	MP->SetPRG_ROM8(0xC,(~1 & AND) | OR);
	MP->SetPRG_ROM8(0xE,(~0 & AND) | OR);
}

void	MMC2_SyncCHR (void)
{
	if (MMC2.LatchState[0] == 0xFD)
		MP->SetCHR_ROM4(0,MMC2.Latch0[0]);
	else if (MMC2.LatchState[0] == 0xFE)
		MP->SetCHR_ROM4(0,MMC2.Latch0[1]);
	else	MP->DbgOut("WARNING: MMC2 latch 0 undefined!");

	if (MMC2.LatchState[1] == 0xFD)
		MP->SetCHR_ROM4(4,MMC2.Latch1[0]);
	else if (MMC2.LatchState[1] == 0xFE)
		MP->SetCHR_ROM4(4,MMC2.Latch1[1]);
	else	MP->DbgOut("WARNING: MMC2 latch 1 undefined!");
}

void	MMC2_SyncMirror (void)
{
	if (MMC2.Mirror & 1)
		MP->Mirror_H();
	else	MP->Mirror_V();
}

int	__cdecl	MMC2_TileHandler (int Bank, int TileNum, int Index)
{
	if ((TileNum == 0xFD) || (TileNum == 0xFE))
	{
		MMC2.LatchState[Bank ? 1 : 0] = TileNum;
		MMC2_SyncCHR();
		return 1;
	}
	return 0;
}

void	__cdecl	MMC2_WriteA (int Bank, int Where, int What)
{
	MMC2.PRG = What & 0xF;
	MMC2.Sync();
}

void	__cdecl	MMC2_WriteB (int Bank, int Where, int What)
{
	MMC2.Latch0[0] = What & 0x1F;
	MMC2.Sync();
}

void	__cdecl	MMC2_WriteC (int Bank, int Where, int What)
{
	MMC2.Latch0[1] = What & 0x1F;
	MMC2.Sync();
}

void	__cdecl	MMC2_WriteD (int Bank, int Where, int What)
{
	MMC2.Latch1[0] = What & 0x1F;
	MMC2.Sync();
}

void	__cdecl	MMC2_WriteE (int Bank, int Where, int What)
{
	MMC2.Latch1[1] = What & 0x1F;
	MMC2.Sync();
}

void	__cdecl	MMC2_WriteF (int Bank, int Where, int What)
{
	MMC2.Mirror = What;
	MMC2.Sync();
}

