#include	"h_MMC3.h"

static	TMMC3	MMC3;

void	MMC3_Init (void (*Sync)(void))
{
	MMC3.PRG[0] = 0x00;	MMC3.PRG[1] = 0x01;

	MMC3.CHR[0] = 0x00;	MMC3.CHR[1] = 0x01;	MMC3.CHR[2] = 0x02;	MMC3.CHR[3] = 0x03;
	MMC3.CHR[4] = 0x04;	MMC3.CHR[5] = 0x05;	MMC3.CHR[6] = 0x06;	MMC3.CHR[7] = 0x07;

	MMC3.IRQenabled = MMC3.IRQcounter = MMC3.IRQlatch = 0;
	MMC3.Cmd = 0;
	MMC3.WriteWRAM = 0;
	MMC3.Mirror = 0;
	MMC3.WriteFunc_WRAM = MP->GetWriteHandler(0x6);
	MP->SetWriteHandler(0x6,MMC3_WriteWRAM);
	MP->SetWriteHandler(0x7,MMC3_WriteWRAM);
	MP->SetWriteHandler(0x8,MMC3_Write89);
	MP->SetWriteHandler(0x9,MMC3_Write89);
	MP->SetWriteHandler(0xA,MMC3_WriteAB);
	MP->SetWriteHandler(0xB,MMC3_WriteAB);
	MP->SetWriteHandler(0xC,MMC3_WriteCD);
	MP->SetWriteHandler(0xD,MMC3_WriteCD);
	MP->SetWriteHandler(0xE,MMC3_WriteEF);
	MP->SetWriteHandler(0xF,MMC3_WriteEF);
	(MMC3.Sync = Sync)();
}

void	MMC3_Destroy (void)
{
	MMC3.Sync = NULL;
}

void	MMC3_SyncMirror (void)
{
	if (MMC3.Mirror & 1)
		MP->Mirror_H();
	else	MP->Mirror_V();
}

int	MMC3_GetPRGBank (int Bank)
{
	u8 Banks[4];
	Banks[0] = MMC3.PRG[0];
	Banks[1] = MMC3.PRG[1];
	Banks[2] = 0x3E;
	Banks[3] = 0x3F;
	if (Bank & 0x1)
		return Banks[Bank];
	else	return Banks[Bank ^ ((MMC3.Cmd & 0x40) >> 5)];
}

int	MMC3_GetCHRBank (int Bank)
{
	return MMC3.CHR[Bank ^ ((MMC3.Cmd & 0x80) >> 5)];
}

void	MMC3_SyncPRG (int AND, int OR)
{
	u8 x;
	for (x = 0; x < 4; x++)
		MP->SetPRG_ROM8(8 | (x << 1),(MMC3_GetPRGBank(x) & AND) | OR);
}

void	MMC3_SyncCHR_ROM (int AND, int OR)
{
	u8 x;
	for (x = 0; x < 8; x++)
		MP->SetCHR_ROM1(x,(MMC3_GetCHRBank(x) & AND) | OR);
}

void	MMC3_SyncCHR_RAM (int AND, int OR)
{
	u8 x;
	for (x = 0; x < 8; x++)
		MP->SetCHR_RAM1(x,(MMC3_GetCHRBank(x) & AND) | OR);
}

int	MMC3_SaveMI (Ar128 MI, int x)
{
	u8 i;
			MI[x++] = MMC3.IRQcounter;
			MI[x++] = MMC3.IRQlatch;
			MI[x++] = MMC3.IRQenabled;
			MI[x++] = MMC3.Cmd;
for (i = 0; i < 2; i++) MI[x++] = MMC3.PRG[i];
for (i = 0; i < 4; i++)	MI[x++] = MMC3.CHR[i++];
for (i = 4; i < 8; i++)	MI[x++] = MMC3.CHR[i];
			MI[x++] = MMC3.WriteWRAM;
			MI[x++] = MMC3.Mirror;
	return x;
}

int	MMC3_LoadMI (const Ar128 MI, int x)
{
	u8 i;
			MMC3.IRQcounter	= MI[x++];
			MMC3.IRQlatch	= MI[x++];
			MMC3.IRQenabled	= MI[x++];
			MMC3.Cmd	= MI[x++];
for (i = 0; i < 2; i++)	MMC3.PRG[i]	= MI[x++];
for (i = 0; i < 4; i++){MMC3.CHR[i++]	= MI[x++];
			MMC3.CHR[i]	= MMC3.CHR[i-1] | 1;}
for (i = 4; i < 8; i++)	MMC3.CHR[i]	= MI[x++];
			MMC3.WriteWRAM	= MI[x++];
			MMC3.Mirror	= MI[x++];
	MMC3.Sync();
	return x;
}

void	__cdecl	MMC3_WriteWRAM (int Bank, int Where, int What)
{
	if (MMC3.WriteWRAM & 0x80)
		MMC3.WriteFunc_WRAM(Bank,Where,What);
}

void	__cdecl	MMC3_Write89 (int Bank, int Where, int What)
{
	if (Where & 1)
		switch (MMC3.Cmd & 0x7)
		{
		case 0:	MMC3.CHR[0] = (What & 0xFE) | 0;
			MMC3.CHR[1] = (What & 0xFE) | 1;break;
		case 1:	MMC3.CHR[2] = (What & 0xFE) | 0;
			MMC3.CHR[3] = (What & 0xFE) | 1;break;
		case 2:	MMC3.CHR[4] = What;		break;
		case 3:	MMC3.CHR[5] = What;		break;
		case 4:	MMC3.CHR[6] = What;		break;
		case 5:	MMC3.CHR[7] = What;		break;
		case 6:	MMC3.PRG[0] = What & 0x3F;	break;
		case 7:	MMC3.PRG[1] = What & 0x3F;	break;
		}
	else	MMC3.Cmd = What;
	MMC3.Sync();
}

void	__cdecl	MMC3_WriteAB (int Bank, int Where, int What)
{
	if (Where & 1)
		MMC3.WriteWRAM = What;
	else	MMC3.Mirror = What;
	MMC3.Sync();
}

void	__cdecl	MMC3_WriteCD (int Bank, int Where, int What)
{
	if (Where & 1)
		MMC3.IRQlatch = What;
	else	MMC3.IRQcounter = MMC3.IRQlatch = What;
}

void	__cdecl	MMC3_WriteEF (int Bank, int Where, int What)
{
	if (Where & 1)
		MMC3.IRQenabled = 1;
	else	MMC3.IRQenabled = 0;
}

void	__cdecl	MMC3_HBlank (int Scanline, int Byte2001)
{
	if (Scanline > 239) return;
	if ((MMC3.IRQenabled) && (Byte2001 & 0x18))
	{
		if (MMC3.IRQcounter == 0)
		{
			MMC3.IRQcounter = MMC3.IRQlatch;
			MP->IRQ();
		}
		else	MMC3.IRQcounter--;
	}
}
