#include	"..\..\DLL\d_UNIF.h"
#include	"..\..\Hardware\h_MMC3.h"

static	struct
{
	u8 WhichGame;
}	Mapper;

static	void	Sync (void)
{
	MMC3_SyncMirror();
	MMC3_SyncPRG((Mapper.WhichGame == 6) ? 0x1F : 0x0F,Mapper.WhichGame << 4);
	MMC3_SyncCHR_ROM((Mapper.WhichGame == 6) ? 0xFF : 0x7F,Mapper.WhichGame << 7);
}

static	void	__cdecl	SaveMI (Ar128 MI)
{
	u8 x = 0;
	x = MMC3_SaveMI(MI,x);
	MI[x++] = Mapper.WhichGame;
}

static	void	__cdecl	LoadMI (const Ar128 MI)
{
	u8 x = 0;
	x = MMC3_LoadMI(MI,x);
	Mapper.WhichGame	= MI[x++];
	Sync();
}

static	void	__cdecl	WriteAB (int Bank,int Where,int What)
{
	switch (Where & 1)
	{
	case 0:	MMC3_WriteAB(Bank,Where,What);	break;
	case 1:	Mapper.WhichGame = What & 0x07;
		if (Mapper.WhichGame == 7)
			Mapper.WhichGame = 6;
		Sync();				break;
	}
}

static	void	__cdecl	UnloadMapper (void)
{
	MMC3_Destroy();
}

static	void	__cdecl	InitMapper (const PMapperParam _MP, int IsHardReset)
{
	MP = _MP;

	Mapper.WhichGame = 0;
	MMC3_Init(Sync);
	MP->SetWriteHandler(0xA,WriteAB);
	MP->SetWriteHandler(0xB,WriteAB);
}

CTMapperInfo	MapperInfo_BMC_1991SuperHiK7in1 =
{
	"BMC-1991SuperHiK7in1",
	-1,
	MS_Full,
	8192,
	InitMapper,
	UnloadMapper,
	MMC3_HBlank,
	NULL,
	SaveMI,
	LoadMI,
	NULL,
	NULL
};