#include	"..\..\DLL\d_UNIF.h"
#include	"..\..\Hardware\h_MMC3.h"

static	struct
{
	u8 BankSize;
	u8 PRGbank, CHRbank;
}	Mapper;

static	void	Sync (void)
{
	int PRGmask[8] = {0x3F,0x1F,0x0F,0x01,0x03,0x00,0x00,0x00};
	MMC3_SyncMirror();
	MMC3_SyncPRG(PRGmask[Mapper.BankSize & 0x7],Mapper.PRGbank << 1);
	if (Mapper.BankSize & 0x20)
		MMC3_SyncCHR_RAM(0x07,0);
	else	MMC3_SyncCHR_ROM(0xFF,Mapper.CHRbank << 3);
}

static	void	__cdecl	SaveMI (Ar128 MI)
{
	u8 x = 0;
	x = MMC3_SaveMI(MI,x);
	MI[x++] = Mapper.BankSize;
	MI[x++] = Mapper.PRGbank;
	MI[x++] = Mapper.CHRbank;
}

static	void	__cdecl	LoadMI (const Ar128 MI)
{
	u8 x = 0;
	x = MMC3_LoadMI(MI,x);
	Mapper.BankSize	= MI[x++];
	Mapper.PRGbank	= MI[x++];
	Mapper.CHRbank	= MI[x++];
	Sync();
}

static	void	__cdecl	Write (int Bank, int Where, int What)
{
	switch (Where)
	{
	case 0xFF0:	Mapper.BankSize = What;	break;
	case 0xFF1:	Mapper.PRGbank = What;	break;
	case 0xFF2:	Mapper.CHRbank = What;	break;
	}
	Sync();
}

static	void	__cdecl	UnloadMapper (void)
{
	MMC3_Destroy();
}

static	void	__cdecl	InitMapper (const PMapperParam _MP, int IsHardReset)
{
	MP = _MP;

	MP->SetWriteHandler(0x5,Write);

	Mapper.BankSize = 0x24;
	Mapper.PRGbank = 0x9F;
	Mapper.CHRbank = 0;
	MMC3_Init(Sync);
}

CTMapperInfo	MapperInfo_BMC_Super24in1SC03 =
{
	"BMC-Super24in1SC03",
	-1,
	MS_Full,
	8192,
	InitMapper,
	UnloadMapper,
	MMC3_HBlank,
	NULL,
	SaveMI,
	LoadMI,
	NULL,
	NULL
};