#include	"..\..\DLL\d_UNIF.h"

static	struct
{
	u8 Reg0, Reg1;
}	Mapper;

static	void	Sync (void)
{
	MP->SetCHR_ROM8(0,Mapper.Reg1 & 0x7);
	if (Mapper.Reg0 & 0x08)
	{
		MP->SetPRG_ROM16(0x8,Mapper.Reg0 & 0x7);
		MP->SetPRG_ROM16(0xC,Mapper.Reg0 & 0x7);
	}
	else	MP->SetPRG_ROM32(0x8,(Mapper.Reg0 & 0x6) >> 1);
	if (Mapper.Reg0 & 0x10)
		MP->Mirror_H();
	else	MP->Mirror_V();
}

static	void	__cdecl	SaveMI (Ar128 MI)
{
	u8 x = 0;
	MI[x++] = Mapper.Reg0;
	MI[x++] = Mapper.Reg1;
}

static	void	__cdecl	LoadMI (const Ar128 MI)
{
	u8 x = 0;
	Mapper.Reg0 = MI[x++];
	Mapper.Reg1 = MI[x++];
	Sync();
}

static	void	__cdecl	Write (int Bank, int Where, int What)
{
	if (Mapper.Reg0 & 0x20)
		return;
	switch (Where & 1)
	{
	case 0:	Mapper.Reg0 = What;	break;
	case 1:	Mapper.Reg1 = What;	break;
	}
	Sync();
}

static	void	__cdecl	InitMapper (const PMapperParam _MP, int IsHardReset)
{
	MP = _MP;
	MP->SetWriteHandler(0x6,Write);
	Mapper.Reg0 = Mapper.Reg1 = 0;
	Sync();
}

CTMapperInfo	MapperInfo_BMC_WS =
{
	"BMC-WS",
	-1,
	MS_Full,
	16384,
	InitMapper,
	NULL,
	NULL,
	NULL,
	SaveMI,
	LoadMI,
	NULL,
	NULL
};