#include	"..\..\DLL\d_UNIF.h"
#include	"..\..\Hardware\h_74xx.h"

static	void	Sync_AMROM (void)
{
	MP->SetPRG_ROM32(0x8,_74xx.Data & 0x3);
	MP->SetCHR_RAM8(0,0);
	if (_74xx.Data & 0x10)
		MP->Mirror_S1();
	else	MP->Mirror_S0();
}
static	void	Sync_ANROM (void)
{
	MP->SetPRG_ROM32(0x8,_74xx.Data & 0x3);
	MP->SetCHR_RAM8(0,0);
	if (_74xx.Data & 0x10)
		MP->Mirror_S1();
	else	MP->Mirror_S0();
}
static	void	Sync_AOROM (void)
{
	MP->SetPRG_ROM32(0x8,_74xx.Data & 0x7);
	MP->SetCHR_RAM8(0,0);
	if (_74xx.Data & 0x10)
		MP->Mirror_S1();
	else	MP->Mirror_S0();
}

static	void	__cdecl	SaveMI (Ar128 MI)
{
	_74xx_SaveMI_D(MI,0);
}

static	void	__cdecl	LoadMI (const Ar128 MI)
{
	_74xx_LoadMI_D(MI,0);
}

static	void	__cdecl	InitMapper_AMROM (const PMapperParam _MP, int IsHardReset)
{
	MP = _MP;
	_74xx_Init(Sync_AMROM,IsHardReset,TRUE);
}
static	void	__cdecl	InitMapper_ANROM (const PMapperParam _MP, int IsHardReset)
{
	MP = _MP;
	_74xx_Init(Sync_ANROM,IsHardReset,FALSE);
}
static	void	__cdecl	InitMapper_AOROM (const PMapperParam _MP, int IsHardReset)
{
	MP = _MP;
	_74xx_Init(Sync_AOROM,IsHardReset,TRUE);
}

CTMapperInfo	MapperInfo_NES_AMROM =
{
	"NES-AMROM",
	-1,
	MS_Full,
	32768,
	InitMapper_AMROM,
	NULL,
	NULL,
	NULL,
	SaveMI,
	LoadMI,
	NULL,
	NULL
};
CTMapperInfo	MapperInfo_NES_ANROM =
{
	"NES-ANROM",
	-1,
	MS_Full,
	32768,
	InitMapper_ANROM,
	NULL,
	NULL,
	NULL,
	SaveMI,
	LoadMI,
	NULL,
	NULL
};
CTMapperInfo	MapperInfo_NES_AOROM =
{
	"NES-AOROM",
	-1,
	MS_Full,
	32768,
	InitMapper_AOROM,
	NULL,
	NULL,
	NULL,
	SaveMI,
	LoadMI,
	NULL,
	NULL
};