#include	"..\..\DLL\d_UNIF.h"
#include	"..\..\Hardware\h_MMC6.h"

static	void	Sync_HKROM (void)
{
	MP->SetPRG_RAM8(0x6,0);
	MMC6_SyncPRG(0x3F,0);
	MMC6_SyncCHR_ROM(0xFF,0);
	MMC6_SyncMirror();
}

static	void	__cdecl	UnloadMapper (void)
{
	MMC6_Destroy();
	UNIF_SaveSRAM();
}

static	void	__cdecl	SaveMI (Ar128 MI)
{
	MMC6_SaveMI(MI,0);
}

static	void	__cdecl	LoadMI (const Ar128 MI)
{
	MMC6_LoadMI(MI,0);
}

static	void	__cdecl	InitMapper_HKROM (const PMapperParam _MP, int IsHardReset)
{
	MP = _MP;
	MMC6_Init(Sync_HKROM);
	UNIF_InitSRAM(1024);
}

CTMapperInfo	MapperInfo_NES_HKROM =
{
	"NES-HKROM",
	-1,
	MS_Nearly,
	8192,
	InitMapper_HKROM,
	UnloadMapper,
	MMC6_HBlank,
	NULL,
	SaveMI,
	LoadMI,
	NULL,
	NULL
};