#include	"..\..\DLL\d_UNIF.h"
#include	"..\..\Hardware\h_FME07.h"

static	void	Sync_JLROM (void)
{
	FME07_SyncPRG(0x3F,0);
	FME07_SyncCHR(0xFF,0);
	FME07_SyncMirror();
}

static	void	Sync_BTR (void)
{
	FME07_SyncPRG(0x3F,0);
	FME07_SyncCHR(0xFF,0);
	FME07_SyncMirror();
}

static	void	__cdecl	SaveMI (Ar128 MI)
{
	FME07_SaveMI(MI,0);
}

static	void	__cdecl	LoadMI (const Ar128 MI)
{
	FME07_LoadMI(MI,0);
}

static	void	__cdecl	UnloadMapper (void)
{
	UNIF_SaveSRAM();
	FME07_Destroy();
}

static	void	__cdecl	InitMapper_JLROM (const PMapperParam _MP, int IsHardReset)
{
	MP = _MP;
	FME07_Init(Sync_JLROM);
}
static	void	__cdecl	InitMapper_BTR (const PMapperParam _MP, int IsHardReset)
{
	MP = _MP;
	FME07_Init(Sync_BTR);
}

CTMapperInfo	MapperInfo_NES_JLROM =
{
	"NES-JLROM",
	-1,
	MS_Full,
	8192,
	InitMapper_JLROM,
	UnloadMapper,
	FME07_HBlank,
	NULL,
	SaveMI,
	LoadMI,
	FME07_MapperSnd,
	NULL
};
CTMapperInfo	MapperInfo_NES_BTR =
{
	"NES-BTR",
	-1,
	MS_Full,
	8192,
	InitMapper_BTR,
	UnloadMapper,
	FME07_HBlank,
	NULL,
	SaveMI,
	LoadMI,
	FME07_MapperSnd,
	NULL
};