#include	"..\..\DLL\d_UNIF.h"
#include	"..\..\Hardware\h_MMC3.h"

static	void	Sync_TFROM (void)
{
	MMC3_SyncPRG(0x3F,0);
	MMC3_SyncCHR_ROM(0x3F,0);
	UNIF_SetMirroring(MMC3_SyncMirror);
}
static	void	Sync_TGROM (void)
{
	MMC3_SyncPRG(0x3F,0);
	MMC3_SyncCHR_RAM(0x7,0);
	MMC3_SyncMirror();
}
static	void	Sync_TKROM (void)
{
	MP->SetPRG_RAM8(0x6,0);
	MMC3_SyncPRG(0x3F,0);
	MMC3_SyncCHR_ROM(0xFF,0);
	MMC3_SyncMirror();
}
static	void	Sync_TLROM (void)
{
	MMC3_SyncPRG(0x3F,0);
	MMC3_SyncCHR_ROM(0xFF,0);
	MMC3_SyncMirror();
}
static	void	Sync_TR1ROM (void)
{
	MMC3_SyncPRG(0x3F,0);
	MMC3_SyncCHR_ROM(0x3F,0);
	MP->Mirror_4();
}
static	void	Sync_TSROM (void)
{
	MP->SetPRG_RAM8(0x6,0);
	MMC3_SyncPRG(0x3F,0);
	MMC3_SyncCHR_ROM(0xFF,0);
	MMC3_SyncMirror();
}

static	void	__cdecl	SaveMI (Ar128 MI)
{
	MMC3_SaveMI(MI,0);
}

static	void	__cdecl	LoadMI (const Ar128 MI)
{
	MMC3_LoadMI(MI,0);
}

static	void	__cdecl	UnloadMapper (void)
{
	UNIF_SaveSRAM();
	MMC3_Destroy();
}

static	void	__cdecl	InitMapper_TFROM (const PMapperParam _MP, int IsHardReset)
{
	MP = _MP;
	MMC3_Init(Sync_TFROM);
}
static	void	__cdecl	InitMapper_TGROM (const PMapperParam _MP, int IsHardReset)
{
	MP = _MP;
	MMC3_Init(Sync_TGROM);
}

static	void	__cdecl	InitMapper_TKROM (const PMapperParam _MP, int IsHardReset)
{
	MP = _MP;
	UNIF_InitSRAM(8192);
	MMC3_Init(Sync_TKROM);
}

static	void	__cdecl	InitMapper_TLROM (const PMapperParam _MP, int IsHardReset)
{
	MP = _MP;
	MMC3_Init(Sync_TLROM);
}

static	void	__cdecl	InitMapper_TR1ROM (const PMapperParam _MP, int IsHardReset)
{
	MP = _MP;
	MMC3_Init(Sync_TR1ROM);
}

static	void	__cdecl	InitMapper_TSROM (const PMapperParam _MP, int IsHardReset)
{
	MP = _MP;
	MMC3_Init(Sync_TSROM);
}

CTMapperInfo	MapperInfo_NES_TFROM =
{
	"NES-TFROM",
	-1,
	MS_Nearly,
	8192,
	InitMapper_TFROM,
	UnloadMapper,
	MMC3_HBlank,
	NULL,
	SaveMI,
	LoadMI,
	NULL,
	NULL
};
CTMapperInfo	MapperInfo_NES_TGROM =
{
	"NES-TGROM",
	-1,
	MS_Nearly,
	8192,
	InitMapper_TGROM,
	UnloadMapper,
	MMC3_HBlank,
	NULL,
	SaveMI,
	LoadMI,
	NULL,
	NULL
};
CTMapperInfo	MapperInfo_NES_TKROM =
{
	"NES-TKROM",
	-1,
	MS_Nearly,
	8192,
	InitMapper_TKROM,
	UnloadMapper,
	MMC3_HBlank,
	NULL,
	SaveMI,
	LoadMI,
	NULL,
	NULL
};
CTMapperInfo	MapperInfo_NES_TLROM =
{
	"NES-TLROM",
	-1,
	MS_Nearly,
	8192,
	InitMapper_TLROM,
	UnloadMapper,
	MMC3_HBlank,
	NULL,
	SaveMI,
	LoadMI,
	NULL,
	NULL
};
CTMapperInfo	MapperInfo_NES_TR1ROM =
{
	"NES-TR1ROM",
	-1,
	MS_Nearly,
	8192,
	InitMapper_TR1ROM,
	UnloadMapper,
	MMC3_HBlank,
	NULL,
	SaveMI,
	LoadMI,
	NULL,
	NULL
};
CTMapperInfo	MapperInfo_NES_TSROM =
{
	"NES-TSROM",
	-1,
	MS_Nearly,
	8192,
	InitMapper_TSROM,
	UnloadMapper,
	MMC3_HBlank,
	NULL,
	SaveMI,
	LoadMI,
	NULL,
	NULL
};