#include	"..\..\DLL\d_UNIF.h"
#include	"..\..\Hardware\h_MMC3.h"

static	struct
{
	u8 PRG;
	u8 CHR;
	u8 Valid;
}	Mapper;

static	void	Sync (void)
{
//	MMC3_SyncCHR_ROM((Mapper.PRG & 0x40) ? 0x7F : 0xFF,(Mapper.CHR & 0x04) << 6);
	if (Mapper.PRG & 0x40)
		MMC3_SyncCHR_ROM(0x7F,(Mapper.CHR & 0x04) << 5);
	else	MMC3_SyncCHR_ROM(0xFF,(Mapper.CHR & 0x04) << 6);
	MMC3_SyncMirror();
	if (Mapper.PRG & 0x80)
	{
		if (Mapper.PRG & 0x20)
			MP->SetPRG_ROM32(0x8,(Mapper.PRG >> 1) & 0x7);
		else
		{
			MP->SetPRG_ROM16(0x8,Mapper.PRG & 0xF);
			MP->SetPRG_ROM16(0xC,Mapper.PRG & 0xF);
		}
	}
	else	MMC3_SyncPRG((Mapper.PRG & 0x40) ? 0x1F : 0x3F,0);
}

static	void	__cdecl	SaveMI (Ar128 MI)
{
	MMC3_SaveMI(MI,0);
}

static	void	__cdecl	LoadMI (const Ar128 MI)
{
	MMC3_LoadMI(MI,0);
}

static	void	__cdecl	UnloadMapper (void)
{
	UNIF_SaveSRAM();
	MMC3_Destroy();
}

static	void	__cdecl	Write5 (int Bank, int Where, int What)
{
	switch (Where & 7)
	{
	case 0:	Mapper.PRG = What;	break;
	case 1:	Mapper.CHR = What;	break;
	}
	Sync();
}

static	void	__cdecl	Write89 (int Bank, int Where, int What)
{
	MMC3_WriteAB(Bank,0,What | What >> 7);
}

static	void	__cdecl	WriteAB (int Bank, int Where, int What)
{
	unsigned char LUT[8] = {0,2,6,1,7,3,4,5};
	MMC3_Write89(Bank,0,(What & 0xC0) | LUT[What & 0x7]);
	Mapper.Valid = 1;
}

static	void	__cdecl	WriteCD (int Bank, int Where, int What)
{
	if (Mapper.Valid)
		MMC3_Write89(Bank,1,What);
	Mapper.Valid = 0;
}

static	void	__cdecl	WriteEF (int Bank, int Where, int What)
{
	if (What)
	{
		MMC3_WriteCD(Bank,0,What);
		MMC3_WriteEF(Bank,1,What);
	}
	else	MMC3_WriteEF(Bank,0,What);
}

static	void	__cdecl	InitMapper (const PMapperParam _MP, int IsHardReset)
{
	MP = _MP;
	MMC3_Init(Sync);
	MP->SetWriteHandler(0x5,Write5);
	MP->SetWriteHandler(0x8,Write89);
	MP->SetWriteHandler(0x9,Write89);
	MP->SetWriteHandler(0xA,WriteAB);
	MP->SetWriteHandler(0xB,WriteAB);
	MP->SetWriteHandler(0xC,WriteCD);
	MP->SetWriteHandler(0xD,WriteCD);
	MP->SetWriteHandler(0xE,WriteEF);
	MP->SetWriteHandler(0xF,WriteEF);
	Mapper.PRG = Mapper.CHR = 0x00;
	Mapper.Valid = 1;
	Sync();
}

CTMapperInfo	MapperInfo_UNL_8237 =
{
	"UNL-8237",
	-1,
	MS_Full,
	8192,
	InitMapper,
	UnloadMapper,
	MMC3_HBlank,
	NULL,
	SaveMI,
	LoadMI,
	NULL,
	NULL
};
