#include	"..\..\DLL\d_UNIF.h"
#include	"..\..\Hardware\h_74xx.h"

static	struct
{
	u8 Latch;
	PWriteFunc Write4;
	void (*Sync)(void);
}	Mapper;

static	void	Sync_72007 (void)
{
	MP->SetPRG_ROM16(0x8,0);
	MP->SetPRG_ROM16(0xC,1);
	MP->SetCHR_ROM8(0,(Mapper.Latch >> 7) & 0x1);
}
static	void	Sync_72008 (void)
{
	MP->SetPRG_ROM32(0x8,(Mapper.Latch >> 2) & 0x1);
	MP->SetCHR_ROM8(0,Mapper.Latch & 0x3);
}
static	void	Sync_0161M (void)
{
	MP->SetPRG_ROM32(0x8,(Mapper.Latch >> 3) & 0x1);
	MP->SetCHR_ROM8(0,Mapper.Latch & 0x7);
}
static	void	Sync_U0115M (void)
{
	MP->SetPRG_ROM32(0x8,(Mapper.Latch >> 2) & 0x1);
	MP->SetCHR_ROM8(0,(Mapper.Latch >> 3) & 0xF);
}
static	void	Sync_0036 (void)
{
	MP->SetPRG_ROM32(0x8,0);
	MP->SetCHR_ROM8(0,(_74xx.Data & 0x80) >> 7);
}
static	void	Sync_0037 (void)
{
	MP->SetPRG_ROM32(0x8,(_74xx.Data & 0x8) >> 3);
	MP->SetCHR_ROM8(0,_74xx.Data & 0x7);
}

static	void	__cdecl	SaveMI (Ar128 MI)
{
	u8 x = 0;
	MI[x++] = Mapper.Latch;
}
static	void	__cdecl	LoadMI (const Ar128 MI)
{
	u8 x = 0;
	Mapper.Latch	= MI[x++];
	Mapper.Sync();
}
static	void	__cdecl	SaveMI2 (Ar128 MI)
{
	_74xx_SaveMI_D(MI,0);
}

static	void	__cdecl	LoadMI2 (const Ar128 MI)
{
	_74xx_LoadMI_D(MI,0);
}

static	void	__cdecl	WriteSA (int Bank, int Where, int What)
{
	if ((Bank == 4) && (Where < 0x018))
		Mapper.Write4(Bank,Where,What);
	if (Where & 0x100)
		Mapper.Latch = What;
	Mapper.Sync();
}
static	void	__cdecl	WriteTC (int Bank, int Where, int What)
{
	if ((Bank == 4) && (Where < 0x018))
		Mapper.Write4(Bank,Where,What);
	if ((Where & 0x103) == 0x102)
		Mapper.Latch = What;
	Sync_U0115M();
}

static	void	InitMapper (const PMapperParam _MP, int IsHardReset)
{
	MP = _MP;
	Mapper.Latch = 0;
	Mapper.Write4 = MP->GetWriteHandler(0x4);
	MP->SetWriteHandler(0x4,WriteSA);
	MP->SetWriteHandler(0x5,WriteSA);
	UNIF_SetMirroring(NULL);
	Mapper.Sync();
}

static	void	__cdecl	InitMapper_0161M (const PMapperParam _MP, int IsHardReset)
{
	Mapper.Sync = Sync_0161M;
	InitMapper(_MP,IsHardReset);
}
static	void	__cdecl	InitMapper_72007 (const PMapperParam _MP, int IsHardReset)
{
	Mapper.Sync = Sync_72007;
	InitMapper(_MP,IsHardReset);
}
static	void	__cdecl	InitMapper_72008 (const PMapperParam _MP, int IsHardReset)
{
	Mapper.Sync = Sync_72008;
	InitMapper(_MP,IsHardReset);
}
static	void	__cdecl	InitMapper_U0115M (const PMapperParam _MP, int IsHardReset)
{
	MP = _MP;
	Mapper.Latch = 0;
	Mapper.Write4 = MP->GetWriteHandler(0x4);
	MP->SetWriteHandler(0x4,WriteTC);
	MP->SetWriteHandler(0x5,WriteTC);
	MP->SetWriteHandler(0x6,WriteTC);
	MP->SetWriteHandler(0x7,WriteTC);
	MP->SetWriteHandler(0xC,WriteTC);
	MP->SetWriteHandler(0xD,WriteTC);
	MP->SetWriteHandler(0xE,WriteTC);
	MP->SetWriteHandler(0xF,WriteTC);
	UNIF_SetMirroring(NULL);
	Sync_U0115M();
}
static	void	__cdecl	InitMapper_0036 (const PMapperParam _MP, int IsHardReset)
{
	MP = _MP;
	_74xx_Init(Sync_0036,IsHardReset,FALSE);
	UNIF_SetMirroring(NULL);
}
static	void	__cdecl	InitMapper_0037 (const PMapperParam _MP, int IsHardReset)
{
	MP = _MP;
	_74xx_Init(Sync_0037,IsHardReset,FALSE);
	UNIF_SetMirroring(NULL);
}

CTMapperInfo	MapperInfo_UNL_SA_0161M =
{
	"UNL-SA-016-1M",
	-1,
	MS_Full,
	32768,
	InitMapper_0161M,
	NULL,
	NULL,
	NULL,
	SaveMI,
	LoadMI,
	NULL,
	NULL
};
CTMapperInfo	MapperInfo_UNL_SA_72007 =
{
	"UNL-SA-72007",
	-1,
	MS_Full,
	32768,
	InitMapper_72007,
	NULL,
	NULL,
	NULL,
	SaveMI,
	LoadMI,
	NULL,
	NULL
};
CTMapperInfo	MapperInfo_UNL_SA_72008 =
{
	"UNL-SA-72008",
	-1,
	MS_Full,
	32768,
	InitMapper_72008,
	NULL,
	NULL,
	NULL,
	SaveMI,
	LoadMI,
	NULL,
	NULL
};
CTMapperInfo	MapperInfo_UNL_TC_U0115M =
{
	"UNL-TC-U01-1.5M",
	-1,
	MS_Full,
	32768,
	InitMapper_U0115M,
	NULL,
	NULL,
	NULL,
	SaveMI,
	LoadMI,
	NULL,
	NULL
};
CTMapperInfo	MapperInfo_UNL_SA_0036 =
{
	"UNL-SA-0036",
	-1,
	MS_Full,
	32768,
	InitMapper_0036,
	NULL,
	NULL,
	NULL,
	SaveMI2,
	LoadMI2,
	NULL,
	NULL
};
CTMapperInfo	MapperInfo_UNL_SA_0037 =
{
	"UNL-SA-0037",
	-1,
	MS_Full,
	32768,
	InitMapper_0037,
	NULL,
	NULL,
	NULL,
	SaveMI2,
	LoadMI2,
	NULL,
	NULL
};
