#include	"..\DLL\d_iNES.h"

static	struct
{
	PWriteFunc Write4;
	u8 PRG[4], CHR[8];
	u8 IRQcounter;
}	Mapper;

static	void	Sync (void)
{
	u8 x;
	for (x = 0; x < 4; x++)
		MP->SetPRG_ROM8(8 | (x << 1),Mapper.PRG[x]);
	for (x = 0; x < 8; x++)
		MP->SetCHR_ROM1(x,Mapper.CHR[x]);
}

static	void	HBlank (int Scanline, int Byte2001)
{
	if ((Scanline < 0) || (Scanline > 239)) return;
	if ((Mapper.IRQcounter) && (Byte2001 & 0x18))
	{
		Mapper.IRQcounter--;
		if (Mapper.IRQcounter == 0)
			MP->IRQ();
	}
}

static	void	Write (int Bank, int Where, int What)
{
	if (Where < 0x018)
	{
		Mapper.Write4(Bank,Where,What);
		return;
	}
	switch (Where)
	{
	case 0x190:	Mapper.PRG[0] = What;	break;
	case 0x191:	Mapper.PRG[1] = What;	break;
	case 0x192:	Mapper.PRG[2] = What;	break;
	case 0x193:	Mapper.PRG[3] = What;	break;

	case 0x198:	Mapper.CHR[0] = What;	break;
	case 0x199:	Mapper.CHR[1] = What;	break;
	case 0x19A:	Mapper.CHR[2] = What;	break;
	case 0x19B:	Mapper.CHR[3] = What;	break;
	case 0x19C:	Mapper.CHR[4] = What;	break;
	case 0x19D:	Mapper.CHR[5] = What;	break;
	case 0x19E:	Mapper.CHR[6] = What;	break;
	case 0x19F:	Mapper.CHR[7] = What;	break;

	case 0x1A0:	Mapper.IRQcounter = What;	break;
	}
	Sync();
}

static	void	UnloadMapper (void)
{
	iNES_UnloadROM();
}

static	void	InitMapper (const PMapperParam _MP, int IsHardReset)
{
	u8 x;

	MP = _MP;

	Mapper.Write4 = MP->GetWriteHandler(0x4);
	MP->SetWriteHandler(0x4,Write);

	for (x = 0; x < 4; x++)	Mapper.PRG[x] = 0xFF;
	for (x = 0; x < 8; x++)	Mapper.CHR[x] = x;
	Mapper.IRQcounter = 0;

	iNES_InitROM();
	Sync();
}

CTMapperInfo	MapperInfo_160 =
{
	"Temporary Dr. PC Jr. support",
	160,
	MS_Partial,
	8192,
	InitMapper,
	UnloadMapper,
	HBlank,
	NULL,
	NULL,
	NULL,
	NULL,
	NULL
};