#include	"..\DLL\d_iNES.h"
#include	"..\Hardware\h_MMC1.h"

static	void	Sync (void)
{
	MMC1_SyncMirror();
	if (MP->PRG_ROM_Size > 262144)
	{
		MP->SetPRG_ROM16(0x8,MMC1_GetPRGBankLo() & 0xF | (MMC1_GetCHRBankLo() & 0x10));
		MP->SetPRG_ROM16(0xC,MMC1_GetPRGBankHi() & 0xF | (MMC1_GetCHRBankLo() & 0x10));
	}
	else	MMC1_SyncPRG(0xF,0);
	if (MP->CHR_ROM_Size)
		MMC1_SyncCHR_ROM(0x1F,0);
	else	MMC1_SyncCHR_RAM(0x01,0);
	MMC1_SyncWRAM();
}

static	void	__cdecl	SaveMI (Ar128 MI)
{
	MMC1_SaveMI(MI,0);
}

static	void	__cdecl	LoadMI (const Ar128 MI)
{
	MMC1_LoadMI(MI,0);
}

static	void	__cdecl	UnloadMapper (void)
{
	iNES_UnloadROM();
	MMC1_Destroy();
}

static	void	__cdecl	InitMapper (const PMapperParam _MP, int IsHardReset)
{
	MP = _MP;
	iNES_InitROM();
	MMC1_Init(Sync);
}

CTMapperInfo	MapperInfo_001 =
{
	"S*ROM (MMC1)",
	1,
	MS_Full,
	16384,
	InitMapper,
	UnloadMapper,
	NULL,
	NULL,
	SaveMI,
	LoadMI,
	NULL,
	NULL
};