#include	"..\DLL\d_iNES.h"

static	struct
{
	PWriteFunc Write4;
	u8 IRQenabled;
	u16_n IRQcounter;
	u8 PRG, CHR;
	u8 Mirror;
}	Mapper;

static	void	Sync (void)
{
	MP->SetPRG_ROM16(0x8,Mapper.PRG);
	MP->SetPRG_ROM16(0xC,7);
	MP->SetCHR_RAM8(0,Mapper.CHR);
	switch (Mapper.Mirror)
	{
	case 0:	MP->Mirror_S0();	break;
	case 1:	MP->Mirror_S1();	break;
	case 2:	MP->Mirror_V();		break;
	case 3:	MP->Mirror_H();		break;
	}
}

static	void	__cdecl	SaveMI (Ar128 MI)
{
	u8 x = 0;
	MI[x++] = Mapper.IRQcounter.b0;
	MI[x++] = Mapper.IRQcounter.b1;
	MI[x++] = Mapper.IRQenabled;
	MI[x++] = Mapper.PRG;
	MI[x++] = Mapper.CHR;
	MI[x++] = Mapper.Mirror;
}

static	void	__cdecl	LoadMI (const Ar128 MI)
{
	u8 x = 0;
	Mapper.IRQcounter.b0	= MI[x++];
	Mapper.IRQcounter.b1	= MI[x++];
	Mapper.IRQenabled	= MI[x++];
	Mapper.PRG		= MI[x++];
	Mapper.CHR		= MI[x++];
	Mapper.Mirror		= MI[x++];
	Sync();
}

static	void	__cdecl	HBlank (int Scanline,int Byte2001)
{
	if ((Mapper.IRQenabled) && (Mapper.IRQcounter.s0))
	{
		if (Mapper.IRQcounter.s0 > (0xFFFF - 114))
			MP->IRQ();
		else	Mapper.IRQcounter.s0 += 114;
	}
}

static	void	__cdecl	Write4 (int Bank, int Where, int What)
{
	if (Where < 0x018)
	{
		Mapper.Write4(Bank,Where,What);
		return;
	}
	switch (Where)
	{
	case 0x2FC:
	case 0x2FD:
	case 0x3FE:
	case 0x2FE:	if (What & 0x10)
				Mapper.Mirror = 1;
			else	Mapper.Mirror = 0;
			Sync();				break;
	case 0x2FF:	if (What & 0x10)
				Mapper.Mirror = 3;
			else	Mapper.Mirror = 2;
			Sync();				break;
	case 0x500:	/* ? */				break;
	case 0x501:	Mapper.IRQenabled = 0;		break;
	case 0x502:	Mapper.IRQcounter.b0 = What;
							break;
	case 0x503:	Mapper.IRQcounter.b1 = What;
			Mapper.IRQenabled = 1;		break;
	}
}

static	void	__cdecl	Write (int Bank, int Where, int What)
{
	Mapper.PRG = (What >> 2) & 0xF;
	Mapper.CHR = What & 3;
	Sync();
}

static	void	__cdecl	UnloadMapper (void)
{
	iNES_UnloadROM();
}

static	void	__cdecl	InitMapper (const PMapperParam _MP, int IsHardReset)
{
	u8 x;

	MP = _MP;
	iNES_InitROM();

	Mapper.Write4 = MP->GetWriteHandler(0x4);
	MP->SetWriteHandler(0x4,Write4);

	for (x = 0x8; x < 0x10; x++)
		MP->SetWriteHandler(x,Write);

	Mapper.PRG = 0;
	Mapper.CHR = 0;
	Mapper.Mirror = 0;
	Mapper.IRQenabled = 0;
	Mapper.IRQcounter.s0 = 0;
	Sync();
}

CTMapperInfo	MapperInfo_006 =
{
	"FFE F4xxx",
	6,
	MS_Partial,
	16384,
	InitMapper,
	UnloadMapper,
	HBlank,
	NULL,
	SaveMI,
	LoadMI,
	NULL,
	NULL
};