#include	"..\DLL\d_iNES.h"
#include	"..\Hardware\h_74xx.h"

static	void	Sync (void)
{
	MP->SetPRG_ROM32(0x8,(_74xx.Data >> 0) & 0xF);
	MP->SetCHR_RAM8 (0,0);	// there exists a mapper11 game with CHR RAM
	MP->SetCHR_ROM8 (0,(_74xx.Data >> 4) & 0xF);
}

static	void	__cdecl	SaveMI (Ar128 MI)
{
	_74xx_SaveMI_D(MI,0);
}

static	void	__cdecl	LoadMI (const Ar128 MI)
{
	_74xx_LoadMI_D(MI,0);
}

static	void	__cdecl	UnloadMapper (void)
{
	iNES_UnloadROM();
	_74xx_Destroy();
}

static	void	__cdecl	InitMapper (const PMapperParam _MP, int IsHardReset)
{
	MP = _MP;
	iNES_InitROM();
	_74xx_Init(Sync,IsHardReset,FALSE);
}

CTMapperInfo	MapperInfo_011 =
{
	"Color Dreams",
	11,
	MS_Full,
	32768,
	InitMapper,
	UnloadMapper,
	NULL,
	NULL,
	SaveMI,
	LoadMI,
	NULL,
	NULL
};
