#include	"..\DLL\d_iNES.h"

static	struct
{
	PWriteFunc Write4;
	u8 IRQenabled;
	u16_n IRQcounter;
	u8 PRG[4], CHR[8];
	u8 Mirror;
}	Mapper;

static	void	Sync (void)
{
	u8 x;
	for (x = 0; x < 4; x++)
		MP->SetPRG_ROM8(0x8 | (x << 1),Mapper.PRG[x]);
	MP->SetCHR_RAM8(0,0);
	for (x = 0; x < 8; x++)
		MP->SetCHR_ROM1(x,Mapper.CHR[x]);
	switch (Mapper.Mirror)
	{
	case 0:	MP->Mirror_S0();	break;
	case 1:	MP->Mirror_S1();	break;
	case 2:	MP->Mirror_V();		break;
	case 3:	MP->Mirror_H();		break;
	}
}

static	void	__cdecl	SaveMI (Ar128 MI)
{
	u8 x = 0, i;
			MI[x++] = Mapper.IRQcounter.b0;
			MI[x++] = Mapper.IRQcounter.b1;
			MI[x++] = Mapper.IRQenabled;
for (i = 0; i < 4; i++)	MI[x++] = Mapper.PRG[i];
for (i = 0; i < 8; i++)	MI[x++] = Mapper.CHR[i];
			MI[x++] = Mapper.Mirror;
}

static	void	__cdecl	LoadMI (const Ar128 MI)
{
	u8 x = 0, i;
			Mapper.IRQcounter.b0	= MI[x++];
			Mapper.IRQcounter.b1	= MI[x++];
			Mapper.IRQenabled	= MI[x++];
for (i = 0; i < 4; i++)	Mapper.PRG[i]		= MI[x++];
for (i = 0; i < 8; i++)	Mapper.CHR[i]		= MI[x++];
			Mapper.Mirror		= MI[x++];
	Sync();
}

static	void	__cdecl	HBlank	(int Scanline, int Byte2001)
{
	if ((Mapper.IRQenabled) && (Mapper.IRQcounter.s0))
	{
		if (Mapper.IRQcounter.s0 > (0xFFFF - 114))
			MP->IRQ();
		else	Mapper.IRQcounter.s0 += 114;
	}
	return;
}

static	void	__cdecl	Write (int Bank, int Where, int What)
{
	if (Where < 0x018)
	{
		Mapper.Write4(Bank,Where,What);
		return;
	}
	switch (Where)
	{
	case 0x2FE:	if (What & 0x10)
				Mapper.Mirror = 1;
			else	Mapper.Mirror = 0;
			Sync();				break;
	case 0x2FF:	if (What & 0x10)
				Mapper.Mirror = 3;
			else	Mapper.Mirror = 2;
			Sync();				break;
	case 0x501:	Mapper.IRQenabled = 0;		break;
	case 0x502:	Mapper.IRQcounter.b0 = What;	break;
	case 0x503:	Mapper.IRQcounter.b1 = What;
			Mapper.IRQenabled = 1;		break;
	case 0x504:	case 0x505:	case 0x506:	case 0x507:
			Mapper.PRG[Where & 3] = What;
			Sync();				break;
	case 0x510:	case 0x511:	case 0x512:	case 0x513:
	case 0x514:	case 0x515:	case 0x516:	case 0x517:
			Mapper.CHR[Where & 7] = What;
			Sync();				break;
	}
}

static	void	__cdecl	UnloadMapper (void)
{
	iNES_UnloadROM();
}

static	void	__cdecl	InitMapper (const PMapperParam _MP, int IsHardReset)
{
	u8 x;
	MP = _MP;
	iNES_InitROM();

	Mapper.Write4 = MP->GetWriteHandler(0x4);
	MP->SetWriteHandler(0x4,Write);

	Mapper.PRG[0] = 0;	Mapper.PRG[1] = 1;	Mapper.PRG[2] = -2;	Mapper.PRG[3] = -1;
	for (x = 0; x < 8; x++)
		Mapper.CHR[x] = x;
	Mapper.Mirror = 0;
	Mapper.IRQenabled = 0;
	Mapper.IRQcounter.s0 = 0;
	Sync();
}

CTMapperInfo	MapperInfo_017 =
{
	"FFE F8xxx",
	17,
	MS_Partial,
	8192,
	InitMapper,
	UnloadMapper,
	HBlank,
	NULL,
	SaveMI,
	LoadMI,
	NULL,
	NULL
};
