#include	"..\DLL\d_iNES.h"

static	struct
{
	u8 PRG[4], CHR[8], NTab[4];
	u8 IRQenabled;
	u16_n IRQcounter;
}	Mapper;


static	void	Sync (void)
{
	u8 x;
	for (x = 0; x < 4; x++)
		MP->SetPRG_ROM8(8 | (x << 1),Mapper.PRG[x]);
	for (x = 0; x < 8; x++)
	{
		if ((!(Mapper.PRG[1] & (x & 4 ? 0x80 : 0x40))) && ((Mapper.CHR[x] & 0xE0) == 0xE0))
			MP->SetCHR_RAM1(x,Mapper.CHR[x] & 0x07);
		else	MP->SetCHR_ROM1(x,Mapper.CHR[x]);
	}

	MP->Mirror_Custom(Mapper.NTab[0] & 1,Mapper.NTab[1] & 1,Mapper.NTab[2] & 1,Mapper.NTab[3] & 1);
	for (x = 0; x < 4; x++)
	{
		if ((Mapper.NTab[x] & 0xE0) != 0xE0)
			MP->SetCHR_ROM1(x+8,Mapper.NTab[x]);
	}
}

static	void	__cdecl	SaveMI (Ar128 MI)
{
	u8 x = 0, i;
			MI[x++] = Mapper.IRQcounter.b0;
			MI[x++] = Mapper.IRQcounter.b1;
			MI[x++] = Mapper.IRQenabled;
for (i = 0; i < 4; i++)	MI[x++] = Mapper.PRG[i];
for (i = 0; i < 8; i++)	MI[x++] = Mapper.CHR[i];
for (i = 0; i < 4; i++)	MI[x++] = Mapper.NTab[i];
}

static	void	__cdecl	LoadMI (const Ar128 MI)
{
	u8 x = 0, i;
			Mapper.IRQcounter.b0	= MI[x++];
			Mapper.IRQcounter.b1	= MI[x++];
			Mapper.IRQenabled	= MI[x++];
for (i = 0; i < 4; i++)	Mapper.PRG[i]		= MI[x++];
for (i = 0; i < 8; i++)	Mapper.CHR[i]		= MI[x++];
for (i = 0; i < 4; i++)	Mapper.NTab[i]		= MI[x++];
}

static	void	__cdecl	HBlank (int Scanline,int Byte2001)
{
	Mapper.IRQcounter.s0 += 114;
	if ((Mapper.IRQenabled) & (Mapper.IRQcounter.s0 >= 0x7FFF))
		MP->IRQ();
	Mapper.IRQcounter.s0 &= 0x7FFF;
}

static	int	__cdecl	Read5 (int Bank, int Where)
{
	u8 result = 0xFF;
	switch (Where & 0x800)
	{
	case 0x000:	result = Mapper.IRQcounter.b0;	break;
	case 0x800:	result = Mapper.IRQcounter.b1;	break;
	}
	return result;
}

static	void	__cdecl	Write5 (int Bank, int Where, int What)
{
	switch (Where & 0x800)
	{
	case 0x000:	Mapper.IRQcounter.b0 = What;		break;
	case 0x800:	Mapper.IRQcounter.b1 = What & 0x7F;
			Mapper.IRQenabled = What & 0x80;	break;
	}
}

static	void	__cdecl	Write8 (int Bank, int Where, int What)
{
	if (Where & 0x800)
		Mapper.CHR[1] = What;
	else	Mapper.CHR[0] = What;
	Sync();
}

static	void	__cdecl	Write9 (int Bank, int Where, int What)
{
	if (Where & 0x800)
		Mapper.CHR[3] = What;
	else	Mapper.CHR[2] = What;
	Sync();
}

static	void	__cdecl	WriteA (int Bank, int Where, int What)
{
	if (Where & 0x800)
		Mapper.CHR[5] = What;
	else	Mapper.CHR[4] = What;
	Sync();
}

static	void	__cdecl	WriteB (int Bank, int Where, int What)
{
	if (Where & 0x800)
		Mapper.CHR[7] = What;
	else	Mapper.CHR[6] = What;
	Sync();
}

static	void	__cdecl	WriteC (int Bank, int Where, int What)
{
	if (Where & 0x800)
		Mapper.NTab[1] = What;
	else	Mapper.NTab[0] = What;
	Sync();
}

static	void	__cdecl	WriteD (int Bank, int Where, int What)
{
	if (Where & 0x800)
		Mapper.NTab[3] = What;
	else	Mapper.NTab[2] = What;
	Sync();
}

static	void	__cdecl	WriteE (int Bank, int Where, int What)
{
	if (Where & 0x800)
		Mapper.PRG[1] = What;
	else	Mapper.PRG[0] = What;
	Sync();
}

static	void	__cdecl	WriteF (int Bank, int Where, int What)
{
	if (Where & 0x800)
		;
	else	Mapper.PRG[2] = What;
	Sync();
}

static	void	__cdecl	UnloadMapper (void)
{
	iNES_UnloadROM();
}

static	void	__cdecl	InitMapper (const PMapperParam _MP, int IsHardReset)
{
	u8 x;
	MP = _MP;
	iNES_InitROM();

	MP->SetReadHandler(0x5,Read5);
	MP->SetWriteHandler(0x5,Write5);
	MP->SetWriteHandler(0x8,Write8);
	MP->SetWriteHandler(0x9,Write9);
	MP->SetWriteHandler(0xA,WriteA);
	MP->SetWriteHandler(0xB,WriteB);
	MP->SetWriteHandler(0xC,WriteC);
	MP->SetWriteHandler(0xD,WriteD);
	MP->SetWriteHandler(0xE,WriteE);
	MP->SetWriteHandler(0xF,WriteF);

	for (x = 0; x < 4; x++)
	{
		Mapper.PRG[x] = 0xFF;
		Mapper.CHR[x | 0] = 0xFF;
		Mapper.CHR[x | 4] = 0xFF;
		Mapper.NTab[x] = 0xFF;
	}
	Mapper.IRQenabled = 0;
	Mapper.IRQcounter.s0 = 0;

	Sync();
}

CTMapperInfo	MapperInfo_019 =
{
	"Namcot 106",
	19,
	MS_Partial,
	8192,
	InitMapper,
	UnloadMapper,
	HBlank,
	NULL,
	SaveMI,
	LoadMI,
	NULL,
	NULL
};