#include	"..\DLL\d_iNES.h"

static	struct
{
	u8 IRQenabled, IRQcounter;
	u8_n IRQlatch;
	u8 Byte9002;
	u8 PRG[3];
	u8_n CHR[8];
	u8 Mirror;
}	Mapper;

static	void	Sync (void)
{
	u8 x;
	MP->SetPRG_ROM8(0x8,Mapper.PRG[0]);
	MP->SetPRG_ROM8(0xA,Mapper.PRG[1]);
	MP->SetPRG_ROM8(0xC,Mapper.PRG[2]);
	MP->SetPRG_ROM8(0xE,-1);
	for (x = 0; x < 8; x++)
		MP->SetCHR_ROM1(x,Mapper.CHR[x].b0);
	switch (Mapper.Mirror & 3)
	{
	case 0:	MP->Mirror_V();		break;
	case 1:	MP->Mirror_H();		break;
	case 2:	MP->Mirror_S1();	break;
	case 3:	MP->Mirror_S0();	break;
	}
}

static	void	__cdecl	SaveMI (Ar128 MI)
{
	u8 x = 0, i;
			MI[x++] = Mapper.IRQcounter;
			MI[x++] = Mapper.IRQenabled;
			MI[x++] = Mapper.IRQlatch.b0;
			MI[x++] = Mapper.Byte9002;
for (i = 0; i < 3; i++)	MI[x++] = Mapper.PRG[i];
for (i = 0; i < 8; i++)	MI[x++] = Mapper.CHR[i].b0;
			MI[x++] = Mapper.Mirror;
}

static	void	__cdecl	LoadMI (const Ar128 MI)
{
	u8 x = 0, i;
			Mapper.IRQcounter	= MI[x++];
			Mapper.IRQenabled	= MI[x++];
			Mapper.IRQlatch.b0	= MI[x++];
			Mapper.Byte9002		= MI[x++];
for (i = 0; i < 3; i++)	Mapper.PRG[i]		= MI[x++];
for (i = 0; i < 8; i++)	Mapper.CHR[i].b0	= MI[x++];
			Mapper.Mirror		= MI[x++];
	Sync();
}

static	void	__cdecl	HBlank (int Scanline,int Byte2001)
{
	if (Mapper.IRQenabled & 2)
	{
		if (Mapper.IRQcounter == 0xFF)
		{
			Mapper.IRQcounter = Mapper.IRQlatch.b0;
			MP->IRQ();
		}
		else	Mapper.IRQcounter++;
	}
}

static	void	__cdecl	Write8 (int Bank, int Where, int What)
{
	if (Where == 0)
	{
		if (Mapper.Byte9002 & 2)
			Mapper.PRG[2] = What;
		else	Mapper.PRG[0] = What;
		Sync();
	}
}

static	void	__cdecl	Write9 (int Bank, int Where, int What)
{
	if (Where == 0)
	{
		Mapper.Mirror = What;
		Sync();
	}
	else if (Where == 2)
		Mapper.Byte9002 = What;
}

static	void	__cdecl	WriteA (int Bank, int Where, int What)
{
	if (Where == 0)
	{
		Mapper.PRG[1] = What;
		Sync();
	}
}

static	void	__cdecl	WriteB (int Bank, int Where, int What)
{
	switch (Where)
	{
	case 0x000:	Mapper.CHR[0].n0 = What & 0xF;	break;
	case 0x002:	Mapper.CHR[0].n1 = What & 0xF;	break;
	case 0x001:
	case 0x004:	Mapper.CHR[1].n0 = What & 0xF;	break;
	case 0x003:
	case 0x006:	Mapper.CHR[1].n1 = What & 0xF;	break;
	}
	Sync();
}

static	void	__cdecl	WriteC (int Bank, int Where, int What)
{
	switch (Where)
	{
	case 0x000:	Mapper.CHR[2].n0 = What & 0xF;	break;
	case 0x002:	Mapper.CHR[2].n1 = What & 0xF;	break;
	case 0x001:
	case 0x004:	Mapper.CHR[3].n0 = What & 0xF;	break;
	case 0x003:
	case 0x006:	Mapper.CHR[3].n1 = What & 0xF;	break;
	}
	Sync();
}

static	void	__cdecl	WriteD (int Bank, int Where, int What)
{
	switch (Where)
	{
	case 0x000:	Mapper.CHR[4].n0 = What & 0xF;	break;
	case 0x002:	Mapper.CHR[4].n1 = What & 0xF;	break;
	case 0x001:
	case 0x004:	Mapper.CHR[5].n0 = What & 0xF;	break;
	case 0x003:
	case 0x006:	Mapper.CHR[5].n1 = What & 0xF;	break;
	}
	Sync();
}

static	void	__cdecl	WriteE (int Bank, int Where, int What)
{
	switch (Where)
	{
	case 0x000:	Mapper.CHR[6].n0 = What & 0xF;	break;
	case 0x002:	Mapper.CHR[6].n1 = What & 0xF;	break;
	case 0x001:
	case 0x004:	Mapper.CHR[7].n0 = What & 0xF;	break;
	case 0x003:
	case 0x006:	Mapper.CHR[7].n1 = What & 0xF;	break;
	}
	Sync();
}

static	void	__cdecl	WriteF (int Bank, int Where, int What)
{
	switch (Where)
	{
	case 0x000:	Mapper.IRQlatch.n0 = What & 0xF;		break;
	case 0x002:	Mapper.IRQlatch.n1 = What & 0xF;		break;
	case 0x003:	if (Mapper.IRQenabled & 1)
				Mapper.IRQenabled |= 2;
			else	Mapper.IRQenabled &= 1;			break;
	case 0x004:	Mapper.IRQenabled = What & 3;
			if (Mapper.IRQenabled & 2)
				Mapper.IRQcounter = Mapper.IRQlatch.b0;	break;
	}
}

static	void	__cdecl	UnloadMapper (void)
{
	iNES_UnloadROM();
}

static	void	__cdecl	InitMapper (const PMapperParam _MP, int IsHardReset)
{
	u8 x;

	MP = _MP;
	iNES_InitROM();

	MP->SetWriteHandler(0x8,Write8);
	MP->SetWriteHandler(0x9,Write9);
	MP->SetWriteHandler(0xA,WriteA);
	MP->SetWriteHandler(0xB,WriteB);
	MP->SetWriteHandler(0xC,WriteC);
	MP->SetWriteHandler(0xD,WriteD);
	MP->SetWriteHandler(0xE,WriteE);
	MP->SetWriteHandler(0xF,WriteF);

	Mapper.IRQenabled = Mapper.IRQcounter = Mapper.IRQlatch.b0 = 0;
	Mapper.Byte9002 = 0;
	Mapper.PRG[0] = 0;	Mapper.PRG[1] = 1;	Mapper.PRG[2] = -2;
	for (x = 0; x < 8; x++)
		Mapper.CHR[x].b0 = x;
	Sync();
}

CTMapperInfo	MapperInfo_021 =
{
	"Konami VRC4",
	21,
	MS_Full,
	8192,
	InitMapper,
	UnloadMapper,
	HBlank,
	NULL,
	SaveMI,
	LoadMI,
	NULL,
	NULL
};
