#include	"..\DLL\d_iNES.h"

static	struct
{
	u8 PRG[2];
	u8 CHR[6];
	u8 Mirror;
}	Mapper;

static	void	Sync (void)
{
	MP->SetPRG_ROM8(0x8,Mapper.PRG[0]);
	MP->SetPRG_ROM8(0xA,Mapper.PRG[1]);
	MP->SetPRG_ROM16(0xC,-1);
	MP->SetCHR_ROM2(0,Mapper.CHR[0]);
	MP->SetCHR_ROM2(2,Mapper.CHR[1]);
	MP->SetCHR_ROM1(4,Mapper.CHR[2]);
	MP->SetCHR_ROM1(5,Mapper.CHR[3]);
	MP->SetCHR_ROM1(6,Mapper.CHR[4]);
	MP->SetCHR_ROM1(7,Mapper.CHR[5]);
	if (Mapper.Mirror)
		MP->Mirror_H();
	else	MP->Mirror_V();
}

static	void	__cdecl	SaveMI (Ar128 MI)
{
	u8 x = 0, i;
for (i = 0; i < 2; i++) MI[x++] = Mapper.PRG[i];
for (i = 0; i < 6; i++)	MI[x++] = Mapper.CHR[i];
			MI[x++] = Mapper.Mirror;
}

static	void	__cdecl	LoadMI (const Ar128 MI)
{
	u8 x = 0, i;
for (i = 0; i < 2; i++) Mapper.PRG[i]		= MI[x++];
for (i = 0; i < 6; i++)	Mapper.CHR[i]		= MI[x++];
			Mapper.Mirror		= MI[x++];
	Sync();
}

static	void	__cdecl	Write89 (int Bank, int Where, int What)
{
	switch (Where & 3)
	{
	case 0:	Mapper.PRG[0] = What & 0x1F;
		Mapper.Mirror = What & 0x40;	break;
	case 1:	Mapper.PRG[1] = What & 0x1F;	break;
	case 2:	Mapper.CHR[0] = What;		break;
	case 3:	Mapper.CHR[1] = What;		break;
	}
	Sync();
}

static	void	__cdecl	WriteAB (int Bank, int Where, int What)
{
	switch (Where & 3)
	{
	case 0:	Mapper.CHR[2] = What;	break;
	case 1:	Mapper.CHR[3] = What;	break;
	case 2:	Mapper.CHR[4] = What;	break;
	case 3:	Mapper.CHR[5] = What;	break;
	}
	Sync();
}

static	void	__cdecl	UnloadMapper (void)
{
	iNES_UnloadROM();
}

static	void	__cdecl	InitMapper (const PMapperParam _MP, int IsHardReset)
{
	u8 x;
	MP = _MP;
	iNES_InitROM();

	MP->SetWriteHandler(0x8,Write89);
	MP->SetWriteHandler(0x9,Write89);
	MP->SetWriteHandler(0xA,WriteAB);
	MP->SetWriteHandler(0xB,WriteAB);

	Mapper.PRG[0] = 0;	Mapper.PRG[1] = 1;
	for (x = 0; x < 6; x++)
		Mapper.CHR[x] = x;
	Mapper.Mirror = 0;
	Sync();
}

CTMapperInfo	MapperInfo_033 =
{
	"Taito TC0190",
	33,
	MS_Partial,
	8192,
	InitMapper,
	UnloadMapper,
	NULL,
	NULL,
	SaveMI,
	LoadMI,
	NULL,
	NULL
};
