#include	"..\DLL\d_iNES.h"
#include	"..\Hardware\h_MMC3.h"

static	struct
{
	u8 Game;
}	Mapper;

static	void	Sync (void)
{
	MMC3_SyncMirror();
	MMC3_SyncPRG((Mapper.Game == 6) ? 0x1F : 0x0F,Mapper.Game << 4);
	MMC3_SyncCHR_ROM((Mapper.Game == 6) ? 0xFF : 0x7F,Mapper.Game << 7);
}

static	void	__cdecl	SaveMI (Ar128 MI)
{
	u8 x = 0;
	x = MMC3_SaveMI(MI,x);
	MI[x++] = Mapper.Game;
}

static	void	__cdecl	LoadMI (const Ar128 MI)
{
	u8 x = 0;
	x = MMC3_LoadMI(MI,x);
	Mapper.Game	= MI[x++];
	Sync();
}

static	void	__cdecl	Write (int Bank,int Where,int What)
{
	switch (Where & 1)
	{
	case 0:	MMC3_WriteAB(Bank,Where,What);	break;
	case 1:	Mapper.Game = What & 0x07;
		if (Mapper.Game == 7)
			Mapper.Game = 6;
		Sync();				break;
	}
}

static	void	__cdecl	UnloadMapper (void)
{
	iNES_UnloadROM();
	MMC3_Destroy();
}

static	void	__cdecl	InitMapper (const PMapperParam _MP, int IsHardReset)
{
	u8 x;
	MP = _MP;
	iNES_InitROM();
	Mapper.Game = 0;
	MMC3_Init(Sync);
	for (x = 0xA; x < 0xC; x++)
		MP->SetWriteHandler(x,Write);	/* need to override writes to $A001 */
}

CTMapperInfo	MapperInfo_044 =
{
	"Super HiK 7 in 1 (MMC3)",
	44,
	MS_Full,
	8192,
	InitMapper,
	UnloadMapper,
	MMC3_HBlank,
	NULL,
	SaveMI,
	LoadMI,
	NULL,
	NULL
};