#include	"..\DLL\d_iNES.h"

static	struct
{
	u8 Game;
}	Mapper;

static	void	Sync (void)
{
	MP->SetCHR_ROM8(0,Mapper.Game);
	MP->SetPRG_ROM16(0x8,Mapper.Game);
	MP->SetPRG_ROM16(0xC,Mapper.Game);
}

static	void	__cdecl	SaveMI (Ar128 MI)
{
	u8 x = 0;
	MI[x++] = Mapper.Game;
}

static	void	__cdecl	LoadMI (const Ar128 MI)
{
	u8 x = 0;
	Mapper.Game = MI[x++];
	Sync();
}

static	void	__cdecl	UnloadMapper (void)
{
	iNES_UnloadROM();
}

static	void	__cdecl	InitMapper (const PMapperParam _MP, int IsHardReset)
{
	MP = _MP;
	iNES_InitROM();

	if (IsHardReset)
		Mapper.Game = 0;
	else	Mapper.Game++;

	Sync();
}

CTMapperInfo	MapperInfo_060 =
{
	"Reset-triggered 4-in-1",
	60,
	MS_Full,
	32768,
	InitMapper,
	UnloadMapper,
	NULL,
	NULL,
	SaveMI,
	LoadMI,
	NULL,
	NULL
};