#include	"..\DLL\d_iNES.h"
#include	"..\Hardware\h_74xx.h"

static	void	Sync (void)
{
	union
	{
		struct
		{
			unsigned Mir_HV  : 1;
			unsigned PRGsizeL: 1;
			unsigned PRG16   : 1;
			unsigned PRGbank : 7;
			unsigned         : 1;
			unsigned PRGsizeH: 1;
			unsigned         : 4;
		};
		struct
		{
			unsigned addr    :16;
		};
	}	Latch;
	u8 x;
	Latch.addr = _74xx.Addr;

	MP->SetCHR_RAM8(0,0);
	
	if ((Latch.PRGbank & 0x60) == 0x60)
		for (x = 0x8; x < 0x10; x++)
			MP->SetPRG_OB4(x);
	switch ((Latch.PRGsizeH << 1) | Latch.PRGsizeL)
	{
	case 0:	MP->SetPRG_ROM16(0x8,(Latch.PRGbank << 1) | Latch.PRG16);
		MP->SetPRG_ROM16(0xC,(Latch.PRGbank << 1) | Latch.PRG16);
							break;
	case 1:	MP->SetPRG_ROM32(0x8,Latch.PRGbank);	break;

	case 2:	MP->SetPRG_ROM8(0x8,((Latch.PRGbank & 0x7F) << 2) | (Latch.PRG16 << 1) | 0);
		MP->SetPRG_ROM8(0xA,((Latch.PRGbank & 0x7F) << 2) | (Latch.PRG16 << 1) | 1);
		MP->SetPRG_ROM8(0xC,((Latch.PRGbank & 0x7F) << 2) | (Latch.PRG16 << 1) | 0);
		MP->SetPRG_ROM8(0xE,((Latch.PRGbank & 0x1F) << 2) | (Latch.PRG16 << 1) | 1);
							break;
	case 3:	MP->SetPRG_ROM8(0x8,((Latch.PRGbank & 0x7F) << 2) | 0);
		MP->SetPRG_ROM8(0xA,((Latch.PRGbank & 0x7F) << 2) | 1);
		MP->SetPRG_ROM8(0xC,((Latch.PRGbank & 0x7F) << 2) | 2);
		MP->SetPRG_ROM8(0xE,((Latch.PRGbank & 0x1F) << 2) | 3);
							break;
	}
	
	if (Latch.Mir_HV)
		MP->Mirror_H();
	else	MP->Mirror_V();

	if (Latch.PRGbank == 0) 
	{
		MP->GetPRG_Ptr4(0xF)[0x02A7] = (u8)0x6F;
		MP->GetPRG_Ptr4(0xF)[0x02A8] = (u8)0xF2;
		MP->GetPRG_Ptr4(0xF)[0x028A] = (u8)0x6F;
		MP->GetPRG_Ptr4(0xF)[0x028B] = (u8)0xF2;
	}
}

static	void	__cdecl	SaveMI (Ar128 MI)
{
	_74xx_SaveMI_A(MI,0);
}

static	void	__cdecl	LoadMI (const Ar128 MI)
{
	_74xx_LoadMI_A(MI,0);
}

static	void	__cdecl	UnloadMapper (void)
{
	iNES_UnloadROM();
	_74xx_Destroy();
}

static	void	__cdecl	InitMapper (const PMapperParam _MP, int IsHardReset)
{
	MP = _MP;
	iNES_InitROM();
	_74xx_Init(Sync,IsHardReset,FALSE);
}

CTMapperInfo	MapperInfo_063 =
{
	"Hello Kitty 255 in 1",
	63,
	MS_Full,
	16384,
	InitMapper,
	UnloadMapper,
	NULL,
	NULL,
	SaveMI,
	LoadMI,
	NULL,
	NULL
};