#include	"..\DLL\d_iNES.h"

static	struct
{
	u8 PRG;
	u8 CHR[4];
	u8 Mirror;
	u16_n IRQcounter;
	u8 IRQenabled;
	u8 IRQpos;
}	Mapper;

static	void	Sync (void)
{
	MP->SetPRG_ROM16(0x8,Mapper.PRG);
	MP->SetPRG_ROM16(0xC,-1);

	MP->SetCHR_ROM2(0,Mapper.CHR[0]);
	MP->SetCHR_ROM2(2,Mapper.CHR[1]);
	MP->SetCHR_ROM2(4,Mapper.CHR[2]);
	MP->SetCHR_ROM2(6,Mapper.CHR[3]);

	switch (Mapper.Mirror & 3)
	{
	case 0:	MP->Mirror_V();		break;
	case 1:	MP->Mirror_H();		break;
	case 2:	MP->Mirror_S0();	break;
	case 3:	MP->Mirror_S1();	break;
	}
}

static	void	__cdecl	SaveMI (Ar128 MI)
{
	u8 x = 0, i;
	MI[x++] = Mapper.IRQcounter.b0;
	MI[x++] = Mapper.IRQcounter.b1;
	MI[x++] = Mapper.IRQenabled;
	MI[x++] = Mapper.IRQpos;
	MI[x++] = Mapper.PRG;
for (i = 0; i < 4; i++)	MI[x++] = Mapper.CHR[i];
	MI[x++] = Mapper.Mirror;
}

static	void	__cdecl	LoadMI (const Ar128 MI)
{
	u8 x = 0, i;
	Mapper.IRQcounter.b0		= MI[x++];
	Mapper.IRQcounter.b1		= MI[x++];
	Mapper.IRQenabled		= MI[x++];
	Mapper.IRQpos			= MI[x++];
	Mapper.PRG			= MI[x++];
for (i = 0; i < 4; i++)	Mapper.CHR[i]	= MI[x++];
	Mapper.Mirror			= MI[x++];
	Sync();
}

static	void	__cdecl	HBlank (int Scanline, int Byte2001)
{
	if (Mapper.IRQenabled)
	{
		if (Mapper.IRQcounter.s0 < 114)
		{
			Mapper.IRQenabled = 0;
			Mapper.IRQcounter.s0 = 0xFFFF;
			MP->IRQ();
		}
		else	Mapper.IRQcounter.s0 -= 114;
	}
}

static	void	__cdecl	Write8 (int Bank, int Where, int What)
{
	if (Where & 0x800)
	{
		Mapper.CHR[0] = What;
		Sync();
	}
}

static	void	__cdecl	Write9 (int Bank, int Where, int What)
{
	if (Where & 0x800)
	{
		Mapper.CHR[1] = What;
		Sync();
	}
}

static	void	__cdecl	WriteA (int Bank, int Where, int What)
{
	if (Where & 0x800)
	{
		Mapper.CHR[2] = What;
		Sync();
	}
}

static	void	__cdecl	WriteB (int Bank, int Where, int What)
{
	if (Where & 0x800)
	{
		Mapper.CHR[3] = What;
		Sync();
	}
}

static	void	__cdecl	WriteC (int Bank, int Where, int What)
{
	if (Where & 0x800)
	{
		if (Mapper.IRQpos)
			Mapper.IRQcounter.b0 = What;
		else	Mapper.IRQcounter.b1 = What;
		Mapper.IRQpos ^= 1;
	}
}

static	void	__cdecl	WriteD (int Bank, int Where, int What)
{
	if (Where & 0x800)
	{
		Mapper.IRQpos = 0;
		Mapper.IRQenabled = (What & 0x10) >> 4;
	}
}

static	void	__cdecl	WriteE (int Bank, int Where, int What)
{
	if (Where & 0x800)
	{
		Mapper.Mirror = What;
		Sync();
	}
}

static	void	__cdecl	WriteF (int Bank, int Where, int What)
{
	if (Where & 0x800)
	{
		Mapper.PRG = What;
		Sync();
	}
}

static	void	__cdecl	UnloadMapper (void)
{
	iNES_UnloadROM();
}

static	void	__cdecl	InitMapper (const PMapperParam _MP, int IsHardReset)
{
	MP = _MP;
	iNES_InitROM();

	MP->SetWriteHandler(0x8,Write8);
	MP->SetWriteHandler(0x9,Write9);
	MP->SetWriteHandler(0xA,WriteA);
	MP->SetWriteHandler(0xB,WriteB);
	MP->SetWriteHandler(0xC,WriteC);
	MP->SetWriteHandler(0xD,WriteD);
	MP->SetWriteHandler(0xE,WriteE);
	MP->SetWriteHandler(0xF,WriteF);

	Mapper.PRG = 0;
	Mapper.CHR[0] = 0;	Mapper.CHR[1] = 0;	Mapper.CHR[2] = 0;	Mapper.CHR[3] = 0;
	Mapper.Mirror = 0;
	Mapper.IRQcounter.s0 = 0;
	Mapper.IRQenabled = Mapper.IRQpos = 0;

	Sync();
}

CTMapperInfo	MapperInfo_067 =
{
	"Sunsoft Mapper #3",
	67,
	MS_Full,
	16384,
	InitMapper,
	UnloadMapper,
	HBlank,
	NULL,
	SaveMI,
	LoadMI,
	NULL,
	NULL
};
